/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.DefaultInvocationGate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultInvocationGateTest {
    @Test
    public void smoke() {
        long currentTime = 0L;
        long minDelayThreshold = 4L;
        long maxDelayThreshold = 8L;
        DefaultInvocationGate gate = new DefaultInvocationGate(minDelayThreshold, maxDelayThreshold, currentTime);
        Assertions.assertTrue((boolean)gate.isTooSoon(0L));
    }

    @Test
    public void closelyRepeatedCallsShouldCauseMaskToIncrease() {
        long currentTime = 0L;
        long minDelayThreshold = 4L;
        long maxDelayThreshold = 8L;
        DefaultInvocationGate gate = new DefaultInvocationGate(minDelayThreshold, maxDelayThreshold, currentTime);
        for (int i = 0; i < 15; ++i) {
            Assertions.assertTrue((boolean)gate.isTooSoon(0L));
        }
        Assertions.assertFalse((boolean)gate.isTooSoon(0L));
        Assertions.assertTrue((gate.getMask() > 15L ? 1 : 0) != 0);
    }

    @Test
    public void stableAtSteadyRate() {
        long currentTime = 0L;
        long minDelayThreshold = 15L;
        long maxDelayThreshold = 30L;
        DefaultInvocationGate gate = new DefaultInvocationGate(minDelayThreshold, maxDelayThreshold, currentTime);
        int t = 0;
        while ((long)t < 4L * minDelayThreshold) {
            gate.isTooSoon(currentTime++);
            Assertions.assertEquals((long)15L, (long)gate.getMask());
            ++t;
        }
    }

    @Test
    public void intermittentCallsShouldCauseMaskToDecrease() {
        long currentTime = 0L;
        long minDelayThreshold = 4L;
        long maxDelayThreshold = 8L;
        DefaultInvocationGate gate = new DefaultInvocationGate(minDelayThreshold, maxDelayThreshold, currentTime);
        int currentMask = 15;
        Assertions.assertFalse((boolean)gate.isTooSoon(currentTime += maxDelayThreshold + 1L));
        Assertions.assertTrue((gate.getMask() < (long)currentMask ? 1 : 0) != 0);
    }

    @Test
    public void maskCanDropToZeroForInfrequentInvocations() {
        long currentTime = 0L;
        long minDelayThreshold = 4L;
        long maxDelayThreshold = 8L;
        DefaultInvocationGate gate = new DefaultInvocationGate(minDelayThreshold, maxDelayThreshold, currentTime);
        int currentMask = 15;
        do {
            Assertions.assertFalse((boolean)gate.isTooSoon(currentTime += maxDelayThreshold + 1L));
            Assertions.assertTrue((gate.getMask() < (long)currentMask ? 1 : 0) != 0);
        } while ((currentMask >>= 2) > 0);
        Assertions.assertEquals((long)0L, (long)gate.getMask());
        Assertions.assertFalse((boolean)gate.isTooSoon(currentTime));
    }
}

