/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.bean;

import ch.ralscha.extdirectspring.bean.ExtDirectResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.context.MessageSource;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;

public class ExtDirectResponseBuilder {
    private final ExtDirectResponse response;
    private final Map<String, Object> result;

    public ExtDirectResponseBuilder(HttpServletRequest request) {
        this.response = new ExtDirectResponse(request);
        this.result = new HashMap<String, Object>();
        this.successful();
        this.response.setResult(this.result);
    }

    public void addErrors(BindingResult bindingResult) {
        this.addErrors(null, null, bindingResult);
    }

    public void addErrors(Locale locale, MessageSource messageSource, BindingResult bindingResult) {
        if (bindingResult != null && bindingResult.hasFieldErrors()) {
            HashMap<String, String> errorMap = new HashMap<String, String>();
            for (FieldError fieldError : bindingResult.getFieldErrors()) {
                String message = fieldError.getDefaultMessage();
                if (messageSource != null) {
                    Locale loc = locale != null ? locale : Locale.getDefault();
                    message = messageSource.getMessage(fieldError.getCode(), fieldError.getArguments(), loc);
                }
                errorMap.put(fieldError.getField(), message);
            }
            if (errorMap.isEmpty()) {
                this.result.put("success", true);
            } else {
                this.result.put("errors", errorMap);
                this.result.put("success", false);
            }
        }
    }

    public void addResultProperty(String key, Object value) {
        this.result.put(key, value);
    }

    public void successful() {
        this.result.put("success", true);
    }

    public void unsuccessful() {
        this.result.put("success", false);
    }

    public ExtDirectResponse build() {
        return this.response;
    }

    public void buildAndWriteUploadResponse(HttpServletResponse servletResponse) throws IOException {
        servletResponse.setContentType("text/html");
        servletResponse.getOutputStream().write("<html><body><textarea>".getBytes());
        ObjectMapper mapper = new ObjectMapper();
        String responseJson = mapper.writeValueAsString((Object)this.response);
        responseJson = responseJson.replace("&quot;", "\\&quot;");
        servletResponse.getOutputStream().write(responseJson.getBytes());
        servletResponse.getOutputStream().write("</textarea></body></html>".getBytes());
    }
}

