/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.controller;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethodType;
import ch.ralscha.extdirectspring.bean.BaseResponse;
import ch.ralscha.extdirectspring.bean.ExtDirectFormLoadResult;
import ch.ralscha.extdirectspring.bean.ExtDirectPollResponse;
import ch.ralscha.extdirectspring.bean.ExtDirectRequest;
import ch.ralscha.extdirectspring.bean.ExtDirectResponse;
import ch.ralscha.extdirectspring.bean.ExtDirectStoreReadRequest;
import ch.ralscha.extdirectspring.bean.ExtDirectStoreResponse;
import ch.ralscha.extdirectspring.bean.GroupInfo;
import ch.ralscha.extdirectspring.bean.SortDirection;
import ch.ralscha.extdirectspring.bean.SortInfo;
import ch.ralscha.extdirectspring.controller.Configuration;
import ch.ralscha.extdirectspring.filter.Filter;
import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import ch.ralscha.extdirectspring.util.JsonHandler;
import ch.ralscha.extdirectspring.util.MethodInfo;
import ch.ralscha.extdirectspring.util.ParameterInfo;
import ch.ralscha.extdirectspring.util.SupportedParameterTypes;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
public class RouterController
implements InitializingBean {
    private static final Log log = LogFactory.getLog(RouterController.class);
    private ConversionService conversionService;
    private ApplicationContext context;
    private JsonHandler jsonHandler;
    @Deprecated
    @Autowired(required=false)
    @Qualifier(value="extDirectSpringExceptionToMessage")
    private Map<String, Map<Class<?>, String>> exceptionToMessage;
    @Autowired(required=false)
    private Configuration configuration;

    @Autowired
    public RouterController(ApplicationContext context, ConversionService conversionService, JsonHandler jsonHandler) {
        this.context = context;
        this.conversionService = conversionService;
        this.jsonHandler = jsonHandler;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.configuration == null) {
            this.configuration = new Configuration();
        }
        if (this.exceptionToMessage != null && this.configuration.getExceptionToMessage() == null) {
            this.configuration.setExceptionToMessage(this.exceptionToMessage.get("extDirectSpringExceptionToMessage"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/poll/{beanName}/{method}/{event}"})
    @ResponseBody
    public ExtDirectPollResponse poll(@PathVariable(value="beanName") String beanName, @PathVariable(value="method") String method, @PathVariable(value="event") String event, HttpServletRequest request, HttpServletResponse response, Locale locale) throws Exception {
        ExtDirectPollResponse directPollResponse;
        block9: {
            directPollResponse = new ExtDirectPollResponse();
            directPollResponse.setName(event);
            try {
                MethodInfo methodInfo = ExtDirectSpringUtil.findMethodInfo(this.context, beanName, method);
                List<ParameterInfo> methodParameters = methodInfo.getParameters();
                Object[] parameters = null;
                if (!methodParameters.isEmpty()) {
                    parameters = new Object[methodParameters.size()];
                    for (int paramIndex = 0; paramIndex < methodParameters.size(); ++paramIndex) {
                        ParameterInfo methodParameter = methodParameters.get(paramIndex);
                        parameters[paramIndex] = methodParameter.isSupportedParameter() ? SupportedParameterTypes.resolveParameter(methodParameter.getType(), request, response, locale) : this.handleRequestParam(request, null, methodParameter);
                    }
                }
                if (this.configuration.isSynchronizeOnSession() || methodInfo.isSynchronizeOnSession()) {
                    HttpSession session = request.getSession(false);
                    if (session != null) {
                        Object mutex;
                        Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
                        synchronized (object) {
                            directPollResponse.setData(ExtDirectSpringUtil.invoke(this.context, beanName, methodInfo, parameters));
                            break block9;
                        }
                    }
                    directPollResponse.setData(ExtDirectSpringUtil.invoke(this.context, beanName, methodInfo, parameters));
                    break block9;
                }
                directPollResponse.setData(ExtDirectSpringUtil.invoke(this.context, beanName, methodInfo, parameters));
            }
            catch (Exception e) {
                log.error((Object)("Error polling method '" + beanName + "." + method + "'"), e.getCause() != null ? e.getCause() : e);
                this.handleException(directPollResponse, e);
            }
        }
        return directPollResponse;
    }

    @RequestMapping(value={"/router"}, method={RequestMethod.POST}, params={"extAction"})
    public String router(@RequestParam(value="extAction") String extAction, @RequestParam(value="extMethod") String extMethod) {
        MethodInfo methodInfo = ExtDirectSpringUtil.findMethodInfo(this.context, extAction, extMethod);
        if (methodInfo.getForwardPath() != null) {
            return methodInfo.getForwardPath();
        }
        throw new IllegalArgumentException("Invalid remoting form method: " + extAction + "." + extMethod);
    }

    @RequestMapping(value={"/router"}, method={RequestMethod.POST}, params={"!extAction"})
    @ResponseBody
    public List<ExtDirectResponse> router(HttpServletRequest request, HttpServletResponse response, Locale locale, @RequestBody Object requestData) {
        ArrayList<ExtDirectRequest> directRequests = new ArrayList<ExtDirectRequest>();
        if (requestData instanceof Map) {
            directRequests.add(this.jsonHandler.convertValue(requestData, ExtDirectRequest.class));
        } else if (requestData instanceof List) {
            for (Object oneRequest : (List)requestData) {
                directRequests.add(this.jsonHandler.convertValue(oneRequest, ExtDirectRequest.class));
            }
        }
        ArrayList<ExtDirectResponse> directResponses = new ArrayList<ExtDirectResponse>();
        for (ExtDirectRequest directRequest : directRequests) {
            ExtDirectResponse directResponse = new ExtDirectResponse(directRequest);
            try {
                MethodInfo methodInfo = ExtDirectSpringUtil.findMethodInfo(this.context, directRequest.getAction(), directRequest.getMethod());
                ExtDirectStoreResponse result = this.processRemotingRequest(request, response, locale, directRequest, methodInfo);
                if (result != null) {
                    if (methodInfo.isType(ExtDirectMethodType.FORM_LOAD) && !ExtDirectFormLoadResult.class.isAssignableFrom(result.getClass())) {
                        result = new ExtDirectFormLoadResult(result);
                    } else if ((methodInfo.isType(ExtDirectMethodType.STORE_MODIFY) || methodInfo.isType(ExtDirectMethodType.STORE_READ)) && !ExtDirectStoreResponse.class.isAssignableFrom(result.getClass()) && this.configuration.isAlwaysWrapStoreResponse()) {
                        result = new ExtDirectStoreResponse((Collection)((Object)result));
                    }
                    directResponse.setResult(result);
                } else if (methodInfo.isType(ExtDirectMethodType.STORE_MODIFY) || methodInfo.isType(ExtDirectMethodType.STORE_READ)) {
                    directResponse.setResult(Collections.emptyList());
                }
            }
            catch (Exception e) {
                log.error((Object)("Error calling method: " + directRequest.getMethod()), e.getCause() != null ? e.getCause() : e);
                this.handleException(directResponse, e);
            }
            directResponses.add(directResponse);
        }
        return directResponses;
    }

    private String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object processRemotingRequest(HttpServletRequest request, HttpServletResponse response, Locale locale, ExtDirectRequest directRequest, MethodInfo methodInfo) throws Exception {
        HttpSession session;
        Object data;
        int jsonParamIndex = 0;
        Map<String, Object> remainingParameters = null;
        ExtDirectStoreReadRequest directStoreReadRequest = null;
        List<Object> directStoreModifyRecords = null;
        if (methodInfo.isType(ExtDirectMethodType.STORE_READ) || methodInfo.isType(ExtDirectMethodType.FORM_LOAD) || methodInfo.isType(ExtDirectMethodType.TREE_LOADER) || methodInfo.isType(ExtDirectMethodType.TREE_LOAD)) {
            data = (List)directRequest.getData();
            if (data != null && data.size() > 0) {
                if (methodInfo.isType(ExtDirectMethodType.STORE_READ)) {
                    directStoreReadRequest = new ExtDirectStoreReadRequest();
                    remainingParameters = this.fillReadRequestFromMap(directStoreReadRequest, (Map)data.get(0));
                } else {
                    remainingParameters = (Map<String, Object>)data.get(0);
                }
                jsonParamIndex = 1;
            }
        } else if (methodInfo.isType(ExtDirectMethodType.STORE_MODIFY)) {
            Class<?> directStoreEntryClass = methodInfo.getCollectionType();
            data = (List)directRequest.getData();
            if (data != null && data.size() > 0) {
                if (data.get(0) instanceof List) {
                    directStoreModifyRecords = this.convertObjectEntriesToType((List)data.get(0), directStoreEntryClass);
                } else {
                    Map jsonData = (Map)data.get(0);
                    Object records = jsonData.get("records");
                    if (records != null) {
                        if (records instanceof List) {
                            directStoreModifyRecords = this.convertObjectEntriesToType((List)records, directStoreEntryClass);
                        } else {
                            directStoreModifyRecords = new ArrayList<Object>();
                            directStoreModifyRecords.add(this.jsonHandler.convertValue(records, directStoreEntryClass));
                        }
                        remainingParameters = new HashMap<String, Object>(jsonData);
                        remainingParameters.remove("records");
                    } else {
                        directStoreModifyRecords = new ArrayList<Object>();
                        directStoreModifyRecords.add(this.jsonHandler.convertValue(jsonData, directStoreEntryClass));
                    }
                }
                jsonParamIndex = 1;
            }
        } else if (methodInfo.isType(ExtDirectMethodType.SIMPLE_NAMED)) {
            data = (Map)directRequest.getData();
            if (data != null && data.size() > 0) {
                remainingParameters = new HashMap<String, Object>((Map<String, Object>)data);
            }
        } else {
            if (methodInfo.isType(ExtDirectMethodType.POLL)) {
                throw new IllegalStateException("this controller does not handle poll calls");
            }
            if (methodInfo.isType(ExtDirectMethodType.FORM_POST)) {
                throw new IllegalStateException("this controller does not handle form posts");
            }
        }
        List<ParameterInfo> methodParameters = methodInfo.getParameters();
        Object[] parameters = null;
        if (!methodParameters.isEmpty()) {
            parameters = new Object[methodParameters.size()];
            for (int paramIndex = 0; paramIndex < methodParameters.size(); ++paramIndex) {
                Object jsonValue;
                ParameterInfo methodParameter = methodParameters.get(paramIndex);
                if (methodParameter.isSupportedParameter()) {
                    parameters[paramIndex] = SupportedParameterTypes.resolveParameter(methodParameter.getType(), request, response, locale);
                    continue;
                }
                if (ExtDirectStoreReadRequest.class.isAssignableFrom(methodParameter.getType())) {
                    parameters[paramIndex] = directStoreReadRequest;
                    continue;
                }
                if (directStoreModifyRecords != null && methodParameter.getCollectionType() != null) {
                    parameters[paramIndex] = directStoreModifyRecords;
                    continue;
                }
                if (methodParameter.isHasRequestParamAnnotation()) {
                    parameters[paramIndex] = this.handleRequestParam(null, remainingParameters, methodParameter);
                    continue;
                }
                if (remainingParameters != null && remainingParameters.containsKey(methodParameter.getName())) {
                    jsonValue = remainingParameters.get(methodParameter.getName());
                    parameters[paramIndex] = this.convertValue(jsonValue, methodParameter);
                    continue;
                }
                if (directRequest.getData() != null && directRequest.getData() instanceof List && ((List)directRequest.getData()).size() > jsonParamIndex) {
                    jsonValue = ((List)directRequest.getData()).get(jsonParamIndex);
                    parameters[paramIndex] = this.convertValue(jsonValue, methodParameter);
                    ++jsonParamIndex;
                    continue;
                }
                throw new IllegalArgumentException("Error, parameter mismatch. Please check your remoting method signature to ensure all supported parameters types are used.");
            }
        }
        if ((this.configuration.isSynchronizeOnSession() || methodInfo.isSynchronizeOnSession()) && (session = request.getSession(false)) != null) {
            Object mutex;
            Object object = mutex = WebUtils.getSessionMutex((HttpSession)session);
            synchronized (object) {
                return ExtDirectSpringUtil.invoke(this.context, directRequest.getAction(), methodInfo, parameters);
            }
        }
        return ExtDirectSpringUtil.invoke(this.context, directRequest.getAction(), methodInfo, parameters);
    }

    private Object convertValue(Object jsonValue, ParameterInfo methodParameter) {
        if (jsonValue != null) {
            if (methodParameter.getType().equals(jsonValue.getClass())) {
                return jsonValue;
            }
            if (this.conversionService.canConvert(TypeDescriptor.forObject((Object)jsonValue), methodParameter.getTypeDescriptor())) {
                return this.conversionService.convert(jsonValue, TypeDescriptor.forObject((Object)jsonValue), methodParameter.getTypeDescriptor());
            }
            return this.jsonHandler.convertValue(jsonValue, methodParameter.getType());
        }
        return jsonValue;
    }

    private Object handleRequestParam(HttpServletRequest request, Map<String, Object> valueContainer, ParameterInfo parameterInfo) {
        if (parameterInfo.getName() != null) {
            Object value = request != null ? request.getParameter(parameterInfo.getName()) : (valueContainer != null ? valueContainer.get(parameterInfo.getName()) : null);
            if (value == null) {
                value = parameterInfo.getDefaultValue();
            }
            if (value != null) {
                return this.convertValue(value, parameterInfo);
            }
            if (parameterInfo.isRequired()) {
                throw new IllegalArgumentException("Missing request parameter: " + parameterInfo.getName());
            }
        }
        return null;
    }

    private Map<String, Object> fillReadRequestFromMap(ExtDirectStoreReadRequest to, Map<String, Object> from) {
        HashSet<String> foundParameters = new HashSet<String>();
        for (Map.Entry<String, Object> entry : from.entrySet()) {
            if (entry.getKey().equals("filter")) {
                ArrayList<Filter> filters = new ArrayList<Filter>();
                List<Map<String, Object>> rawFilters = this.jsonHandler.readValue((String)entry.getValue(), new TypeReference<List<Map<String, Object>>>(){});
                for (Map<String, Object> rawFilter : rawFilters) {
                    filters.add(Filter.createFilter(rawFilter, this.conversionService));
                }
                to.setFilters(filters);
                foundParameters.add(entry.getKey());
                continue;
            }
            if (entry.getKey().equals("sort") && entry.getValue() != null && entry.getValue() instanceof List) {
                ArrayList<SortInfo> sorters = new ArrayList<SortInfo>();
                List rawSorters = (List)entry.getValue();
                for (Map<String, Object> aRawSorter : rawSorters) {
                    sorters.add(SortInfo.create(aRawSorter));
                }
                to.setSorters(sorters);
                foundParameters.add(entry.getKey());
                continue;
            }
            if (entry.getKey().equals("group") && entry.getValue() != null && entry.getValue() instanceof List) {
                ArrayList<GroupInfo> groups = new ArrayList<GroupInfo>();
                List rawGroups = (List)entry.getValue();
                for (Map<String, Object> aRawGroupInfo : rawGroups) {
                    groups.add(GroupInfo.create(aRawGroupInfo));
                }
                to.setGroups(groups);
                foundParameters.add(entry.getKey());
                continue;
            }
            PropertyDescriptor descriptor = BeanUtils.getPropertyDescriptor(to.getClass(), (String)entry.getKey());
            if (descriptor == null || descriptor.getWriteMethod() == null) continue;
            try {
                descriptor.getWriteMethod().invoke((Object)to, this.conversionService.convert(entry.getValue(), descriptor.getPropertyType()));
                foundParameters.add(entry.getKey());
            }
            catch (IllegalArgumentException e) {
                log.error((Object)"fillObjectFromMap", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"fillObjectFromMap", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)"fillObjectFromMap", (Throwable)e);
            }
        }
        if (to.getLimit() != null) {
            if (to.getPage() != null && to.getStart() == null) {
                to.setStart(to.getLimit() * (to.getPage() - 1));
            } else if (to.getPage() == null && to.getStart() != null) {
                to.setPage(to.getStart() / to.getLimit() + 1);
            }
        }
        if (to.getSort() != null && to.getDir() != null) {
            ArrayList<SortInfo> sorters = new ArrayList<SortInfo>();
            sorters.add(new SortInfo(to.getSort(), SortDirection.fromString(to.getDir())));
            to.setSorters(sorters);
        }
        if (to.getGroupBy() != null && to.getGroupDir() != null) {
            ArrayList<GroupInfo> groups = new ArrayList<GroupInfo>();
            groups.add(new GroupInfo(to.getGroupBy(), SortDirection.fromString(to.getGroupDir())));
            to.setGroups(groups);
        }
        HashMap<String, Object> remainingParameters = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : from.entrySet()) {
            if (foundParameters.contains(entry.getKey())) continue;
            remainingParameters.put(entry.getKey(), entry.getValue());
        }
        return remainingParameters;
    }

    private List<Object> convertObjectEntriesToType(List<Object> records, Class<?> directStoreType) {
        if (records != null) {
            ArrayList<Object> convertedList = new ArrayList<Object>();
            for (Object record : records) {
                Object convertedObject = this.jsonHandler.convertValue(record, directStoreType);
                convertedList.add(convertedObject);
            }
            return convertedList;
        }
        return null;
    }

    private void handleException(BaseResponse response, Exception e) {
        Throwable cause = e.getCause() != null ? e.getCause() : e;
        response.setType("exception");
        response.setMessage(this.configuration.getMessage(cause));
        if (this.configuration.isSendStacktrace()) {
            response.setWhere(this.getStackTrace(cause));
        } else {
            response.setWhere(null);
        }
    }
}

