/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import ch.ralscha.extdirectspring.annotation.ExtDirectMethod;
import ch.ralscha.extdirectspring.annotation.ExtDirectMethodType;
import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import ch.ralscha.extdirectspring.util.ParameterInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfo {
    private static final LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();
    private List<ParameterInfo> parameters;
    private Method method;
    private String forwardPath;
    private ExtDirectMethodType type;
    private Class<?> collectionType;
    private boolean synchronizeOnSession;

    public MethodInfo(Class<?> clazz, Method method) {
        ExtDirectMethod extDirectMethodAnnotation;
        this.method = method;
        RequestMapping methodAnnotation = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
        if (methodAnnotation != null) {
            RequestMapping classAnnotation = (RequestMapping)AnnotationUtils.findAnnotation(clazz, RequestMapping.class);
            String path = null;
            if (this.hasValue(classAnnotation)) {
                path = classAnnotation.value()[0];
            }
            if (this.hasValue(methodAnnotation)) {
                String methodPath = methodAnnotation.value()[0];
                path = path != null ? path + methodPath : methodPath;
            }
            if (path != null) {
                if (path.charAt(0) == '/' && path.length() > 1) {
                    path = path.substring(1, path.length());
                }
                this.forwardPath = "forward:" + path;
            }
        }
        if ((extDirectMethodAnnotation = (ExtDirectMethod)AnnotationUtils.findAnnotation((Method)method, ExtDirectMethod.class)) != null) {
            this.type = extDirectMethodAnnotation.value();
            this.synchronizeOnSession = extDirectMethodAnnotation.synchronizeOnSession();
        }
        this.parameters = MethodInfo.buildParameterList(clazz, method);
        for (ParameterInfo parameter : this.parameters) {
            if (parameter.getCollectionType() == null) continue;
            this.collectionType = parameter.getCollectionType();
            break;
        }
    }

    private boolean hasValue(RequestMapping requestMapping) {
        return requestMapping != null && requestMapping.value() != null && requestMapping.value().length > 0 && StringUtils.hasText((String)requestMapping.value()[0]);
    }

    private static List<ParameterInfo> buildParameterList(Class<?> clazz, Method method) {
        ArrayList<ParameterInfo> params = new ArrayList<ParameterInfo>();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = null;
        String[] parameterNames = null;
        Method methodWithAnnotation = ExtDirectSpringUtil.findMethodWithAnnotation(method, ExtDirectMethod.class);
        if (methodWithAnnotation != null) {
            parameterAnnotations = methodWithAnnotation.getParameterAnnotations();
            parameterNames = discoverer.getParameterNames(methodWithAnnotation);
        }
        for (int paramIndex = 0; paramIndex < parameterTypes.length; ++paramIndex) {
            String paramName = null;
            if (parameterNames != null) {
                paramName = parameterNames[paramIndex];
            }
            Annotation[] paramAnnotations = null;
            if (parameterAnnotations != null) {
                paramAnnotations = parameterAnnotations[paramIndex];
            }
            params.add(new ParameterInfo(clazz, method, paramIndex, parameterTypes[paramIndex], paramName, paramAnnotations));
        }
        return params;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getForwardPath() {
        return this.forwardPath;
    }

    public List<ParameterInfo> getParameters() {
        return this.parameters;
    }

    public Class<?> getCollectionType() {
        return this.collectionType;
    }

    public boolean isType(ExtDirectMethodType methodType) {
        return this.type == methodType;
    }

    public boolean isSynchronizeOnSession() {
        return this.synchronizeOnSession;
    }
}

