/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.filter;

import ch.ralscha.extdirectspring.filter.BooleanFilter;
import ch.ralscha.extdirectspring.filter.Comparison;
import ch.ralscha.extdirectspring.filter.DateFilter;
import ch.ralscha.extdirectspring.filter.ListFilter;
import ch.ralscha.extdirectspring.filter.NumericFilter;
import ch.ralscha.extdirectspring.filter.StringFilter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.ConversionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Filter {
    private final String field;

    public Filter(String field) {
        this.field = field;
    }

    public String getField() {
        return this.field;
    }

    public static Filter createFilter(Map<String, Object> jsonData, ConversionService conversionService) {
        String type = (String)jsonData.get("type");
        Object source = jsonData.get("value");
        if (type == null) {
            if (jsonData.containsKey("property") && jsonData.containsKey("value")) {
                String property = (String)jsonData.get("property");
                Object filterValue = source;
                if (filterValue instanceof Number) {
                    return new NumericFilter(property, (Number)filterValue, null);
                }
                if (filterValue instanceof Boolean) {
                    return new BooleanFilter(property, (Boolean)filterValue);
                }
                return new StringFilter(property, filterValue.toString());
            }
            return null;
        }
        String field = (String)jsonData.get("field");
        if (type.equals("numeric")) {
            String comparison = (String)jsonData.get("comparison");
            Number value = (Number)conversionService.convert(source, Number.class);
            return new NumericFilter(field, value, Comparison.fromString(comparison));
        }
        if (type.equals("string")) {
            String value = (String)source;
            return new StringFilter(field, value);
        }
        if (type.equals("date")) {
            String comparison = (String)jsonData.get("comparison");
            String value = (String)source;
            return new DateFilter(field, value, Comparison.fromString(comparison));
        }
        if (type.equals("list")) {
            Object value = source;
            if (value instanceof String) {
                String[] values = ((String)value).split(",");
                return new ListFilter(field, Arrays.asList(values));
            }
            return new ListFilter(field, (List)value);
        }
        if (type.equals("boolean")) {
            boolean value = (Boolean)source;
            return new BooleanFilter(field, value);
        }
        return null;
    }
}

