/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.base.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountedCompleter;
import java.util.function.BiConsumer;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;

public class RangeTask
extends CountedCompleter<Void> {
    private final int lo;
    private final int hi;
    private final int chunkSize;
    private final @NonNull BiConsumer<Integer, Integer> rangeConsumer;
    private final @NonNull CompletableFuture<Void> future;

    public RangeTask(int lo, int hi, int chunkSize, @NonNull BiConsumer<Integer, Integer> rangeConsumer, @NonNull CompletableFuture<Void> future) {
        this(null, lo, hi, chunkSize, rangeConsumer, future);
    }

    RangeTask(@Nullable RangeTask parent, int lo, int hi, int chunkSize, @NonNull BiConsumer<Integer, Integer> rangeConsumer, @NonNull CompletableFuture<Void> future) {
        super(parent, (hi - lo - 1) / chunkSize);
        this.chunkSize = chunkSize;
        this.lo = lo;
        this.hi = hi;
        this.rangeConsumer = rangeConsumer;
        this.future = future;
    }

    @Override
    public void compute() {
        int n;
        for (n = this.lo; n < this.hi - this.chunkSize; n += this.chunkSize) {
            new RangeTask(this, n, n + this.chunkSize, this.chunkSize, this.rangeConsumer, this.future).fork();
        }
        if (!this.future.isCancelled()) {
            this.rangeConsumer.accept(n, Math.min(n + this.chunkSize, this.hi));
        }
        this.tryComplete();
    }

    @Override
    public void onCompletion(CountedCompleter<?> caller) {
        if (this.getRoot().getPendingCount() == 0) {
            this.future.complete(null);
        }
    }

    @Override
    public boolean onExceptionalCompletion(Throwable ex, CountedCompleter<?> caller) {
        this.future.completeExceptionally(ex);
        return true;
    }

    public static void forEach(int lo, int hi, int chunkSize, BiConsumer<Integer, Integer> action) {
        new RangeTask(null, lo, hi, chunkSize, action, new CompletableFuture<Void>()).invoke();
    }

    public static CompletableFuture<Void> fork(int lo, int hi, int chunkSize, BiConsumer<Integer, Integer> action) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        RangeTask rangeTask = new RangeTask(null, lo, hi, chunkSize, action, future);
        rangeTask.fork();
        return future;
    }
}

