/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.base.converter;

import java.io.IOException;
import java.nio.CharBuffer;
import java.text.ParseException;
import org.jhotdraw8.annotation.NonNull;
import org.jhotdraw8.annotation.Nullable;
import org.jhotdraw8.base.converter.IdResolver;
import org.jhotdraw8.base.converter.IdSupplier;

public interface Converter<T> {
    default public @Nullable T fromString(@NonNull CharSequence in, @Nullable IdResolver idResolver) throws ParseException {
        return this.fromString(CharBuffer.wrap(in), idResolver);
    }

    public @Nullable T fromString(@NonNull CharBuffer var1, @Nullable IdResolver var2) throws ParseException;

    default public @Nullable T fromString(@NonNull CharBuffer in) throws ParseException {
        return this.fromString(in, null);
    }

    default public @Nullable T fromString(@NonNull CharSequence in) throws ParseException {
        CharBuffer buf = CharBuffer.wrap(in);
        T value = this.fromString(buf);
        if (buf.remaining() != 0) {
            throw new ParseException(buf.remaining() + " remaining character(s) not consumed. remaining: \"" + String.valueOf(buf) + "\".", buf.position());
        }
        return value;
    }

    default public @NonNull T fromStringNonNull(@NonNull CharBuffer in, @Nullable IdResolver idResolver) throws ParseException {
        T m = this.fromString(in, idResolver);
        if (m == null) {
            throw new ParseException("Value must not be null.", 0);
        }
        return m;
    }

    default public @NonNull T fromStringNonNull(@NonNull CharBuffer in) throws ParseException {
        T m = this.fromString(in);
        if (m == null) {
            throw new ParseException("Value must not be null.", 0);
        }
        return m;
    }

    default public @NonNull T fromStringNonNull(@NonNull CharSequence in, @Nullable IdResolver idResolver) throws ParseException {
        T m = this.fromString(in, idResolver);
        if (m == null) {
            throw new ParseException("Value must not be null.", 0);
        }
        return m;
    }

    default public @NonNull T fromStringNonNull(@NonNull CharSequence in) throws ParseException {
        T m = this.fromString(in);
        if (m == null) {
            throw new ParseException("Value must not be null.", 0);
        }
        return m;
    }

    public @Nullable T getDefaultValue();

    default public @Nullable String getHelpText() {
        return null;
    }

    default public boolean needsIdResolver() {
        return false;
    }

    public <TT extends T> void toString(Appendable var1, @Nullable IdSupplier var2, @Nullable TT var3) throws IOException;

    default public <TT extends T> void toString(@NonNull Appendable out, @Nullable TT value) throws IOException {
        this.toString(out, null, value);
    }

    default public <TT extends T> @NonNull String toString(@Nullable TT value) {
        StringBuilder out = new StringBuilder();
        try {
            this.toString(out, value);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return out.toString();
    }

    default public <TT extends T> @NonNull String toString(@Nullable IdSupplier idSupplier, @Nullable TT value) {
        StringBuilder out = new StringBuilder();
        try {
            this.toString(out, idSupplier, value);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return out.toString();
    }
}

