/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw8.base.io;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import org.jhotdraw8.annotation.NonNull;

public class CharBufferReader
extends Reader {
    private final CharBuffer buf;

    public CharBufferReader(CharBuffer buf) {
        this.buf = buf;
    }

    @Override
    public int read() {
        if (this.buf.remaining() <= 0) {
            return -1;
        }
        return this.buf.get();
    }

    @Override
    public int read(@NonNull CharBuffer target) throws IOException {
        return this.buf.read(target);
    }

    @Override
    public int read(char @NonNull [] cbuf, int off, int len) {
        len = Math.min(len, this.buf.remaining());
        this.buf.get(cbuf, off, len);
        return len;
    }

    @Override
    public void close() {
    }
}

