/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.commons.smartswitch.impl;

import ch.sourcepond.commons.smartswitch.api.ToDefaultSwitchObserver;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmartSwitch<T>
implements InvocationHandler,
ServiceListener {
    private static final Logger LOG = LoggerFactory.getLogger(SmartSwitch.class);
    private final Supplier<T> supplier;
    private final Consumer<T> shutdownHookOrNull;
    private final ToDefaultSwitchObserver<T> observerOrNull;
    private final Executor executor;
    private volatile T defaultService;

    SmartSwitch(Executor pExecutor, Supplier<T> pSupplier, Consumer<T> pShutdownHookOrNull, ToDefaultSwitchObserver<T> pObserverOrNull) {
        this.executor = pExecutor;
        this.supplier = pSupplier;
        this.shutdownHookOrNull = pShutdownHookOrNull;
        this.observerOrNull = pObserverOrNull;
    }

    private void informObserver() {
        if (this.observerOrNull != null) {
            this.executor.execute(() -> this.observerOrNull.defaultInitialized(this.defaultService));
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (1 == event.getType()) {
            this.shutdownDefaultService();
        }
    }

    private synchronized void shutdownDefaultService() {
        if (this.defaultService != null) {
            if (this.shutdownHookOrNull != null) {
                T toBeShutdown = this.defaultService;
                this.executor.execute(() -> {
                    try {
                        this.shutdownHookOrNull.accept(toBeShutdown);
                    }
                    catch (Exception e) {
                        LOG.warn(e.getMessage(), (Throwable)e);
                    }
                });
            }
            this.defaultService = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        T obj = this.defaultService;
        if (obj == null) {
            SmartSwitch smartSwitch = this;
            synchronized (smartSwitch) {
                obj = this.defaultService;
                if (obj == null) {
                    this.defaultService = obj = this.supplier.get();
                    this.informObserver();
                }
            }
        }
        return method.invoke(obj, args);
    }
}

