/*
 * Decompiled with CFR 0.152.
 */
package ch.sourcepond.commons.smartswitch.impl;

import ch.sourcepond.commons.smartswitch.api.SmartSwitchBuilder;
import ch.sourcepond.commons.smartswitch.api.ToDefaultSwitchObserver;
import ch.sourcepond.commons.smartswitch.impl.SmartSwitch;
import ch.sourcepond.commons.smartswitch.impl.SmartSwitchFactory;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.wiring.BundleWiring;

final class SmartSwitchBuilderImpl<T>
implements SmartSwitchBuilder<T> {
    private final SmartSwitchFactory smartSwitchFactory;
    private final Executor executor;
    private final Class<T> serviceInterface;
    private final BundleContext context;
    private volatile String filterOrNull;
    private volatile ToDefaultSwitchObserver<T> observerOrNull;
    private volatile Consumer<T> shutdownHookOrNull;

    SmartSwitchBuilderImpl(SmartSwitchFactory pSmartSwitchFactory, Executor pExecutor, BundleContext pContext, Class<T> pServiceInterface) {
        this.smartSwitchFactory = pSmartSwitchFactory;
        this.executor = pExecutor;
        this.context = pContext;
        this.serviceInterface = pServiceInterface;
    }

    private T createProxy(SmartSwitch<T> pSmartSwitch) {
        return (T)Proxy.newProxyInstance(((BundleWiring)this.context.getBundle().adapt(BundleWiring.class)).getClassLoader(), new Class[]{this.serviceInterface}, pSmartSwitch);
    }

    public SmartSwitchBuilder<T> setObserver(ToDefaultSwitchObserver<T> pObserver) {
        this.observerOrNull = pObserver;
        return this;
    }

    public SmartSwitchBuilder<T> setFilter(String pFilter) {
        try {
            this.context.createFilter(pFilter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        this.filterOrNull = pFilter;
        return this;
    }

    public SmartSwitchBuilder<T> setShutdownHook(Consumer<T> pShutdownHook) {
        if (pShutdownHook == null) {
            throw new NullPointerException("ShutdownHook is null");
        }
        this.shutdownHookOrNull = pShutdownHook;
        return this;
    }

    private String createServiceFilter() {
        if (this.filterOrNull == null) {
            return String.format("(%s=%s)", "objectClass", this.serviceInterface.getName());
        }
        return String.format("(&(%s=%s)%s)", "objectClass", this.serviceInterface.getName(), this.filterOrNull);
    }

    public T build(Supplier<T> pSupplier) {
        Objects.requireNonNull(pSupplier, "Supplier is null");
        SmartSwitch<T> smartSwitch = this.smartSwitchFactory.create(this.executor, pSupplier, this.shutdownHookOrNull, this.observerOrNull);
        try {
            this.context.addServiceListener(smartSwitch, this.createServiceFilter());
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return this.createProxy(smartSwitch);
    }
}

