/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm;

import ch.squaredesk.nova.comm.DefaultMarshallerFactory;
import ch.squaredesk.nova.comm.retrieving.MessageUnmarshaller;
import ch.squaredesk.nova.comm.sending.MessageMarshaller;
import ch.squaredesk.nova.metrics.Metrics;
import java.util.Objects;

public abstract class CommAdapterBuilder<MessageType, CommAdapterType> {
    private final Class<MessageType> messageTypeClass;
    public MessageMarshaller<MessageType, String> messageMarshaller;
    public MessageUnmarshaller<String, MessageType> messageUnmarshaller;
    public Metrics metrics;

    protected CommAdapterBuilder(Class<MessageType> messageTypeClass) {
        this.messageTypeClass = messageTypeClass;
    }

    public CommAdapterBuilder<MessageType, CommAdapterType> setMessageMarshaller(MessageMarshaller<MessageType, String> marshaller) {
        this.messageMarshaller = marshaller;
        return this;
    }

    public CommAdapterBuilder<MessageType, CommAdapterType> setMessageUnmarshaller(MessageUnmarshaller<String, MessageType> unmarshaller) {
        this.messageUnmarshaller = unmarshaller;
        return this;
    }

    public CommAdapterBuilder<MessageType, CommAdapterType> setMetrics(Metrics metrics) {
        this.metrics = metrics;
        return this;
    }

    private void baseValidate() {
        if (this.messageMarshaller == null) {
            this.messageMarshaller = DefaultMarshallerFactory.getMarshallerForMessageType(this.messageTypeClass);
        }
        if (this.messageUnmarshaller == null) {
            this.messageUnmarshaller = DefaultMarshallerFactory.getUnmarshallerForMessageType(this.messageTypeClass);
        }
        if (this.metrics == null) {
            this.metrics = new Metrics();
        }
        Objects.requireNonNull(this.messageMarshaller, " messageMarshaller instance must not be null");
        Objects.requireNonNull(this.messageUnmarshaller, " messageUnmarshaller instance must not be null");
    }

    protected void validate() {
    }

    protected abstract CommAdapterType createInstance();

    public final CommAdapterType build() {
        this.baseValidate();
        this.validate();
        return this.createInstance();
    }
}

