/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.sending;

import ch.squaredesk.nova.comm.sending.MessageMarshaller;
import ch.squaredesk.nova.comm.sending.MessageSendingInfo;
import ch.squaredesk.nova.comm.sending.MetricsCollector;
import ch.squaredesk.nova.metrics.Metrics;
import io.reactivex.Completable;
import java.util.Objects;

public abstract class MessageSender<DestinationType, InternalMessageType, TransportMessageType, TransportSpecificInfoType> {
    private final MessageMarshaller<InternalMessageType, TransportMessageType> messageMarshaller;
    private final MetricsCollector metricsCollector;

    protected MessageSender(MessageMarshaller<InternalMessageType, TransportMessageType> messageMarshaller, Metrics metrics) {
        this(null, messageMarshaller, metrics);
    }

    protected MessageSender(String identifier, MessageMarshaller<InternalMessageType, TransportMessageType> messageMarshaller, Metrics metrics) {
        Objects.requireNonNull(metrics, "metrics must not be null");
        Objects.requireNonNull(messageMarshaller, "messageMarshaller instance must be provided");
        this.messageMarshaller = messageMarshaller;
        this.metricsCollector = new MetricsCollector(identifier, metrics);
    }

    protected abstract Completable doSend(TransportMessageType var1, MessageSendingInfo<DestinationType, TransportSpecificInfoType> var2);

    public Completable sendMessage(DestinationType destination, InternalMessageType message, TransportSpecificInfoType transportSpecificSendingInfo) {
        Objects.requireNonNull(destination, "destination must not be null");
        try {
            TransportMessageType transportMessage = message == null ? null : (TransportMessageType)this.messageMarshaller.marshal(message);
            MessageSendingInfo msi = new MessageSendingInfo.Builder().withDestination(destination).withTransportSpecificInfo(transportSpecificSendingInfo).build();
            Completable retVal = this.doSend(transportMessage, msi);
            this.metricsCollector.messageSent(destination);
            return retVal;
        }
        catch (Throwable t) {
            return Completable.error((Throwable)t);
        }
    }
}

