/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.sending;

import java.util.Objects;

public class MessageSendingInfo<DestinationType, TransportSpecificInfoType> {
    public final DestinationType destination;
    public final TransportSpecificInfoType transportSpecificInfo;

    protected MessageSendingInfo(Builder<DestinationType, TransportSpecificInfoType> builder) {
        this.destination = ((Builder)builder).destination;
        this.transportSpecificInfo = ((Builder)builder).transportSpecificInfo;
    }

    public String toString() {
        return "{destination=" + this.destination + ", transportSpecificInfo=" + this.transportSpecificInfo + '}';
    }

    public static class Builder<DestinationType, TransportSpecificInfoType> {
        private DestinationType destination;
        private TransportSpecificInfoType transportSpecificInfo;

        public Builder<DestinationType, TransportSpecificInfoType> withDestination(DestinationType destination) {
            this.destination = destination;
            return this;
        }

        public Builder<DestinationType, TransportSpecificInfoType> withTransportSpecificInfo(TransportSpecificInfoType transportSpecificInfo) {
            this.transportSpecificInfo = transportSpecificInfo;
            return this;
        }

        public MessageSendingInfo<DestinationType, TransportSpecificInfoType> build() {
            this.validate();
            return new MessageSendingInfo(this);
        }

        private void validate() {
            Objects.requireNonNull(this.destination, "destination must not be null");
        }
    }
}

