/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.websockets.client;

import ch.squaredesk.nova.comm.websockets.CloseReason;
import ch.squaredesk.nova.comm.websockets.Endpoint;
import ch.squaredesk.nova.comm.websockets.EndpointStreamSource;
import ch.squaredesk.nova.comm.websockets.WebSocket;
import java.util.function.Consumer;

public class ClientEndpoint<MessageType>
extends Endpoint<MessageType> {
    private final WebSocket<MessageType> webSocket;

    public ClientEndpoint(EndpointStreamSource<MessageType> endpointStreamSource, WebSocket<MessageType> webSocket, Consumer<CloseReason> closeAction) {
        super(endpointStreamSource, closeAction);
        this.webSocket = webSocket;
    }

    public void send(MessageType message) {
        this.webSocket.send(message);
    }

    public String getUserProperty(String propertyId) {
        return this.getUserProperty(propertyId, String.class);
    }

    public <PropertyType> PropertyType getUserProperty(String propertyId, Class<PropertyType> propertyType) {
        return this.webSocket.getUserProperty(propertyId, propertyType);
    }

    public void setUserProperty(String propertyId, Object value) {
        this.webSocket.setUserProperty(propertyId, value);
    }

    public void clearUserProperties() {
        this.webSocket.clearUserProperties();
    }
}

