/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.crypto;

import chat.dim.crypto.CryptographyKey;
import chat.dim.crypto.Factories;
import chat.dim.crypto.PublicKey;
import chat.dim.crypto.SignKey;
import chat.dim.type.Map;

public interface PrivateKey
extends SignKey {
    public PublicKey getPublicKey();

    public static PrivateKey generate(String algorithm) {
        Factory factory = PrivateKey.getFactory(algorithm);
        if (factory == null) {
            throw new NullPointerException("key algorithm not support: " + algorithm);
        }
        return factory.generatePrivateKey();
    }

    public static PrivateKey parse(java.util.Map<String, Object> key) {
        if (key == null) {
            return null;
        }
        if (key instanceof PrivateKey) {
            return (PrivateKey)key;
        }
        if (key instanceof Map) {
            key = ((Map)key).getMap();
        }
        String algorithm = CryptographyKey.getAlgorithm(key);
        if (!1.$assertionsDisabled && algorithm == null) {
            throw new AssertionError((Object)("failed to get algorithm name from key: " + key));
        }
        Factory factory = PrivateKey.getFactory(algorithm);
        if (factory == null) {
            factory = PrivateKey.getFactory("*");
            if (!1.$assertionsDisabled && factory == null) {
                throw new AssertionError((Object)("cannot parse key: " + key));
            }
        }
        return factory.parsePrivateKey(key);
    }

    public static Factory getFactory(String algorithm) {
        return Factories.privateKeyFactories.get(algorithm);
    }

    public static void register(String algorithm, Factory factory) {
        Factories.privateKeyFactories.put(algorithm, factory);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static interface Factory {
        public PrivateKey generatePrivateKey();

        public PrivateKey parsePrivateKey(java.util.Map<String, Object> var1);
    }
}

