/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.crypto;

import chat.dim.crypto.CryptographyKey;
import chat.dim.crypto.Factories;
import chat.dim.crypto.VerifyKey;
import java.util.Map;

public interface PublicKey
extends VerifyKey {
    public static PublicKey parse(Map<String, Object> key) {
        if (key == null) {
            return null;
        }
        if (key instanceof PublicKey) {
            return (PublicKey)key;
        }
        if (key instanceof chat.dim.type.Map) {
            key = ((chat.dim.type.Map)key).getMap();
        }
        String algorithm = CryptographyKey.getAlgorithm(key);
        if (!1.$assertionsDisabled && algorithm == null) {
            throw new AssertionError((Object)("failed to get algorithm name from key: " + key));
        }
        Factory factory = PublicKey.getFactory(algorithm);
        if (factory == null) {
            factory = PublicKey.getFactory("*");
            if (!1.$assertionsDisabled && factory == null) {
                throw new AssertionError((Object)("cannot parse key: " + key));
            }
        }
        return factory.parsePublicKey(key);
    }

    public static Factory getFactory(String algorithm) {
        return Factories.publicKeyFactories.get(algorithm);
    }

    public static void register(String algorithm, Factory factory) {
        Factories.publicKeyFactories.put(algorithm, factory);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static interface Factory {
        public PublicKey parsePublicKey(Map<String, Object> var1);
    }
}

