/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.crypto;

import chat.dim.crypto.CryptographyKey;
import chat.dim.crypto.DecryptKey;
import chat.dim.crypto.EncryptKey;
import chat.dim.crypto.Factories;
import chat.dim.type.Map;

public interface SymmetricKey
extends EncryptKey,
DecryptKey {
    public static final String AES = "AES";
    public static final String DES = "DES";

    public static SymmetricKey generate(String algorithm) {
        Factory factory = SymmetricKey.getFactory(algorithm);
        if (factory == null) {
            throw new NullPointerException("key algorithm not support: " + algorithm);
        }
        return factory.generateSymmetricKey();
    }

    public static SymmetricKey parse(java.util.Map<String, Object> key) {
        if (key == null) {
            return null;
        }
        if (key instanceof SymmetricKey) {
            return (SymmetricKey)key;
        }
        if (key instanceof Map) {
            key = ((Map)key).getMap();
        }
        String algorithm = CryptographyKey.getAlgorithm(key);
        if (!1.$assertionsDisabled && algorithm == null) {
            throw new AssertionError((Object)("failed to get algorithm name from key: " + key));
        }
        Factory factory = SymmetricKey.getFactory(algorithm);
        if (factory == null) {
            factory = SymmetricKey.getFactory("*");
            if (!1.$assertionsDisabled && factory == null) {
                throw new AssertionError((Object)("cannot parse key: " + key));
            }
        }
        return factory.parseSymmetricKey(key);
    }

    public static Factory getFactory(String algorithm) {
        return Factories.symmetricKeyFactories.get(algorithm);
    }

    public static void register(String algorithm, Factory factory) {
        Factories.symmetricKeyFactories.put(algorithm, factory);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static interface Factory {
        public SymmetricKey generateSymmetricKey();

        public SymmetricKey parseSymmetricKey(java.util.Map<String, Object> var1);
    }
}

