/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model.beans;

import chat.octet.model.enums.FinishReason;

public class CompletionResult {
    private String content;
    private int promptTokens;
    private int completionTokens;
    private FinishReason finishReason;

    CompletionResult(String content, int promptTokens, int completionTokens, FinishReason finishReason) {
        this.content = content;
        this.promptTokens = promptTokens;
        this.completionTokens = completionTokens;
        this.finishReason = finishReason;
    }

    public static CompletionResultBuilder builder() {
        return new CompletionResultBuilder();
    }

    public String getContent() {
        return this.content;
    }

    public int getPromptTokens() {
        return this.promptTokens;
    }

    public int getCompletionTokens() {
        return this.completionTokens;
    }

    public FinishReason getFinishReason() {
        return this.finishReason;
    }

    public String toString() {
        return "CompletionResult(content=" + this.getContent() + ", promptTokens=" + this.getPromptTokens() + ", completionTokens=" + this.getCompletionTokens() + ", finishReason=" + (Object)((Object)this.getFinishReason()) + ")";
    }

    public static class CompletionResultBuilder {
        private String content;
        private int promptTokens;
        private int completionTokens;
        private FinishReason finishReason;

        CompletionResultBuilder() {
        }

        public CompletionResultBuilder content(String content) {
            this.content = content;
            return this;
        }

        public CompletionResultBuilder promptTokens(int promptTokens) {
            this.promptTokens = promptTokens;
            return this;
        }

        public CompletionResultBuilder completionTokens(int completionTokens) {
            this.completionTokens = completionTokens;
            return this;
        }

        public CompletionResultBuilder finishReason(FinishReason finishReason) {
            this.finishReason = finishReason;
            return this;
        }

        public CompletionResult build() {
            return new CompletionResult(this.content, this.promptTokens, this.completionTokens, this.finishReason);
        }

        public String toString() {
            return "CompletionResult.CompletionResultBuilder(content=" + this.content + ", promptTokens=" + this.promptTokens + ", completionTokens=" + this.completionTokens + ", finishReason=" + (Object)((Object)this.finishReason) + ")";
        }
    }
}

