/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model.beans;

import chat.octet.model.LlamaService;
import chat.octet.model.beans.Token;
import chat.octet.model.enums.FinishReason;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Status {
    private static final Logger log = LoggerFactory.getLogger(Status.class);
    private final int id;
    private final int contextSize;
    private final int[] inputIds;
    private List<Token> generateTokens;
    private int inputLength;
    private int pastTokenSize;
    private String initialSystemPrompt;

    public Status() {
        this.id = RandomUtils.nextInt((int)10000, (int)50000);
        this.contextSize = LlamaService.getContextSize();
        this.inputIds = new int[this.contextSize];
        this.generateTokens = Lists.newArrayList();
        this.inputLength = 0;
        this.pastTokenSize = 0;
    }

    public Status(Status srcStatus) {
        this.id = srcStatus.getId();
        this.contextSize = srcStatus.getContextSize();
        this.inputIds = new int[this.contextSize];
        this.generateTokens = Lists.newArrayList();
        if (srcStatus.getInputIds() != null && srcStatus.getInputLength() > 0) {
            System.arraycopy(srcStatus.getInputIds(), 0, this.inputIds, 0, srcStatus.getInputLength());
        }
        this.inputLength = srcStatus.getInputLength();
        this.pastTokenSize = srcStatus.getPastTokenSize();
        this.initialSystemPrompt = srcStatus.getInitialSystemPrompt();
    }

    public void appendTokens(int[] tokens) {
        if (this.inputLength + tokens.length >= this.contextSize) {
            this.reset();
            log.warn("Input tokens has exceeded the context size, status will be reset immediately, sequence id: {}.", (Object)this.id);
        }
        System.arraycopy(tokens, 0, this.inputIds, this.pastTokenSize, tokens.length);
        this.inputLength += tokens.length;
    }

    public void appendNextToken(Token token) {
        this.generateTokens.add(token);
        this.inputIds[this.inputLength] = token.getId();
        ++this.inputLength;
        ++this.pastTokenSize;
    }

    public void addPastTokensSize(int size) {
        this.pastTokenSize += size;
    }

    public void copyToStatus(Status srcStatus) {
        if (FinishReason.TRUNCATED == srcStatus.getFinishReason()) {
            this.reset();
        } else {
            System.arraycopy(srcStatus.getInputIds(), 0, this.inputIds, 0, srcStatus.getInputLength());
            this.inputLength = srcStatus.getInputLength();
            this.pastTokenSize = srcStatus.getPastTokenSize();
            this.generateTokens = Lists.newArrayList(srcStatus.getGenerateTokens());
            this.initialSystemPrompt = srcStatus.getInitialSystemPrompt();
        }
    }

    public int getLogitsIndex() {
        return this.generateTokens.isEmpty() && this.pastTokenSize > 0 ? this.pastTokenSize - 1 : 0;
    }

    public FinishReason getFinishReason() {
        return this.generateTokens == null || this.generateTokens.isEmpty() ? FinishReason.UNKNOWN : this.generateTokens.get(this.generateTokens.size() - 1).getFinishReason();
    }

    public int[] subInputIds(int startIndexInclusive, int endIndexExclusive) {
        return ArrayUtils.subarray((int[])this.inputIds, (int)startIndexInclusive, (int)endIndexExclusive);
    }

    public int[] subInputIds(int startIndexInclusive) {
        return this.subInputIds(startIndexInclusive, this.inputLength);
    }

    public void reset() {
        LlamaService.clearCache(this.id);
        Arrays.fill(this.inputIds, 0);
        this.pastTokenSize = 0;
        this.inputLength = 0;
        this.initialSystemPrompt = null;
    }

    public int getId() {
        return this.id;
    }

    public int getContextSize() {
        return this.contextSize;
    }

    public int[] getInputIds() {
        return this.inputIds;
    }

    public List<Token> getGenerateTokens() {
        return this.generateTokens;
    }

    public int getInputLength() {
        return this.inputLength;
    }

    public int getPastTokenSize() {
        return this.pastTokenSize;
    }

    public String getInitialSystemPrompt() {
        return this.initialSystemPrompt;
    }

    public void setInitialSystemPrompt(String initialSystemPrompt) {
        this.initialSystemPrompt = initialSystemPrompt;
    }
}

