/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model.components.processor;

import chat.octet.model.components.processor.LogitsProcessor;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class LogitsProcessorList
implements LogitsProcessor {
    private final Set<LogitsProcessor> logitsProcessors = Sets.newHashSet();

    public LogitsProcessorList add(LogitsProcessor processor) {
        for (LogitsProcessor p : this.logitsProcessors) {
            if (p.getClass() != processor.getClass()) continue;
            return this;
        }
        this.logitsProcessors.add(processor);
        return this;
    }

    public boolean isEmpty() {
        return this.logitsProcessors.isEmpty();
    }

    @Override
    public float[] processor(@Nullable int[] inputTokenIds, @Nonnull float[] scores, Object ... args) {
        Preconditions.checkNotNull((Object)scores, (Object)"Scores cannot be null");
        float[] result = null;
        for (LogitsProcessor pro : this.logitsProcessors) {
            result = pro.processor(inputTokenIds, scores, args);
        }
        return Optional.ofNullable(result).orElse(scores);
    }
}

