/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model.parameters;

import chat.octet.model.enums.LlamaRoPEScalingType;
import chat.octet.model.enums.ModelType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Arrays;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
@JsonDeserialize(builder=ModelParameterBuilder.class)
public class ModelParameter {
    private String modelPath;
    private String modelName;
    private String modelType;
    private int contextSize;
    @Nullable
    private Integer mainGpu;
    private int gpuLayers;
    private int seed;
    private boolean logitsAll;
    private boolean vocabOnly;
    private boolean mmap;
    private boolean mlock;
    private boolean embedding;
    private int threads;
    private int threadsBatch;
    private int batchSize;
    @Nullable
    private String loraBase;
    @Nullable
    private String loraPath;
    private float loraScale;
    @Nullable
    private float[] tensorSplit;
    private float ropeFreqBase;
    private float ropeFreqScale;
    @Nullable
    private Integer gqa;
    @Nullable
    private Float rmsNormEps;
    private boolean mulMatQ;
    private boolean verbose;
    private int ropeScalingType;
    private float yarnExtFactor;
    private float yarnAttnFactor;
    private float yarnBetaFast;
    private float yarnBetaSlow;
    private int yarnOrigCtx;
    private boolean offloadKqv;
    private int splitMode;
    private boolean doPooling;

    private static String $default$modelType() {
        return ModelType.LLAMA2.name();
    }

    private static int $default$contextSize() {
        return 512;
    }

    private static int $default$gpuLayers() {
        return 0;
    }

    private static int $default$seed() {
        return -1;
    }

    private static boolean $default$logitsAll() {
        return false;
    }

    private static boolean $default$vocabOnly() {
        return false;
    }

    private static boolean $default$mmap() {
        return true;
    }

    private static boolean $default$mlock() {
        return false;
    }

    private static boolean $default$embedding() {
        return false;
    }

    private static int $default$threads() {
        return 4;
    }

    private static int $default$threadsBatch() {
        return 4;
    }

    private static int $default$batchSize() {
        return 512;
    }

    private static float $default$ropeFreqBase() {
        return 0.0f;
    }

    private static float $default$ropeFreqScale() {
        return 0.0f;
    }

    private static boolean $default$mulMatQ() {
        return true;
    }

    private static boolean $default$verbose() {
        return false;
    }

    private static int $default$ropeScalingType() {
        return LlamaRoPEScalingType.LLAMA_ROPE_SCALING_UNSPECIFIED.getType();
    }

    private static float $default$yarnExtFactor() {
        return -1.0f;
    }

    private static float $default$yarnAttnFactor() {
        return 1.0f;
    }

    private static float $default$yarnBetaFast() {
        return 32.0f;
    }

    private static float $default$yarnBetaSlow() {
        return 1.0f;
    }

    private static boolean $default$offloadKqv() {
        return true;
    }

    private static int $default$splitMode() {
        return 1;
    }

    private static boolean $default$doPooling() {
        return true;
    }

    ModelParameter(String modelPath, String modelName, String modelType, int contextSize, @Nullable Integer mainGpu, int gpuLayers, int seed, boolean logitsAll, boolean vocabOnly, boolean mmap, boolean mlock, boolean embedding, int threads, int threadsBatch, int batchSize, @Nullable String loraBase, @Nullable String loraPath, float loraScale, @Nullable float[] tensorSplit, float ropeFreqBase, float ropeFreqScale, @Nullable Integer gqa, @Nullable Float rmsNormEps, boolean mulMatQ, boolean verbose, int ropeScalingType, float yarnExtFactor, float yarnAttnFactor, float yarnBetaFast, float yarnBetaSlow, int yarnOrigCtx, boolean offloadKqv, int splitMode, boolean doPooling) {
        this.modelPath = modelPath;
        this.modelName = modelName;
        this.modelType = modelType;
        this.contextSize = contextSize;
        this.mainGpu = mainGpu;
        this.gpuLayers = gpuLayers;
        this.seed = seed;
        this.logitsAll = logitsAll;
        this.vocabOnly = vocabOnly;
        this.mmap = mmap;
        this.mlock = mlock;
        this.embedding = embedding;
        this.threads = threads;
        this.threadsBatch = threadsBatch;
        this.batchSize = batchSize;
        this.loraBase = loraBase;
        this.loraPath = loraPath;
        this.loraScale = loraScale;
        this.tensorSplit = tensorSplit;
        this.ropeFreqBase = ropeFreqBase;
        this.ropeFreqScale = ropeFreqScale;
        this.gqa = gqa;
        this.rmsNormEps = rmsNormEps;
        this.mulMatQ = mulMatQ;
        this.verbose = verbose;
        this.ropeScalingType = ropeScalingType;
        this.yarnExtFactor = yarnExtFactor;
        this.yarnAttnFactor = yarnAttnFactor;
        this.yarnBetaFast = yarnBetaFast;
        this.yarnBetaSlow = yarnBetaSlow;
        this.yarnOrigCtx = yarnOrigCtx;
        this.offloadKqv = offloadKqv;
        this.splitMode = splitMode;
        this.doPooling = doPooling;
    }

    public static ModelParameterBuilder builder() {
        return new ModelParameterBuilder();
    }

    public String getModelPath() {
        return this.modelPath;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getModelType() {
        return this.modelType;
    }

    public int getContextSize() {
        return this.contextSize;
    }

    @Nullable
    public Integer getMainGpu() {
        return this.mainGpu;
    }

    public int getGpuLayers() {
        return this.gpuLayers;
    }

    public int getSeed() {
        return this.seed;
    }

    public boolean isLogitsAll() {
        return this.logitsAll;
    }

    public boolean isVocabOnly() {
        return this.vocabOnly;
    }

    public boolean isMmap() {
        return this.mmap;
    }

    public boolean isMlock() {
        return this.mlock;
    }

    public boolean isEmbedding() {
        return this.embedding;
    }

    public int getThreads() {
        return this.threads;
    }

    public int getThreadsBatch() {
        return this.threadsBatch;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    @Nullable
    public String getLoraBase() {
        return this.loraBase;
    }

    @Nullable
    public String getLoraPath() {
        return this.loraPath;
    }

    public float getLoraScale() {
        return this.loraScale;
    }

    @Nullable
    public float[] getTensorSplit() {
        return this.tensorSplit;
    }

    public float getRopeFreqBase() {
        return this.ropeFreqBase;
    }

    public float getRopeFreqScale() {
        return this.ropeFreqScale;
    }

    @Nullable
    public Integer getGqa() {
        return this.gqa;
    }

    @Nullable
    public Float getRmsNormEps() {
        return this.rmsNormEps;
    }

    public boolean isMulMatQ() {
        return this.mulMatQ;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public int getRopeScalingType() {
        return this.ropeScalingType;
    }

    public float getYarnExtFactor() {
        return this.yarnExtFactor;
    }

    public float getYarnAttnFactor() {
        return this.yarnAttnFactor;
    }

    public float getYarnBetaFast() {
        return this.yarnBetaFast;
    }

    public float getYarnBetaSlow() {
        return this.yarnBetaSlow;
    }

    public int getYarnOrigCtx() {
        return this.yarnOrigCtx;
    }

    public boolean isOffloadKqv() {
        return this.offloadKqv;
    }

    public int getSplitMode() {
        return this.splitMode;
    }

    public boolean isDoPooling() {
        return this.doPooling;
    }

    public String toString() {
        return "ModelParameter(modelPath=" + this.getModelPath() + ", modelName=" + this.getModelName() + ", modelType=" + this.getModelType() + ", contextSize=" + this.getContextSize() + ", mainGpu=" + this.getMainGpu() + ", gpuLayers=" + this.getGpuLayers() + ", seed=" + this.getSeed() + ", logitsAll=" + this.isLogitsAll() + ", vocabOnly=" + this.isVocabOnly() + ", mmap=" + this.isMmap() + ", mlock=" + this.isMlock() + ", embedding=" + this.isEmbedding() + ", threads=" + this.getThreads() + ", threadsBatch=" + this.getThreadsBatch() + ", batchSize=" + this.getBatchSize() + ", loraBase=" + this.getLoraBase() + ", loraPath=" + this.getLoraPath() + ", loraScale=" + this.getLoraScale() + ", tensorSplit=" + Arrays.toString(this.getTensorSplit()) + ", ropeFreqBase=" + this.getRopeFreqBase() + ", ropeFreqScale=" + this.getRopeFreqScale() + ", gqa=" + this.getGqa() + ", rmsNormEps=" + this.getRmsNormEps() + ", mulMatQ=" + this.isMulMatQ() + ", verbose=" + this.isVerbose() + ", ropeScalingType=" + this.getRopeScalingType() + ", yarnExtFactor=" + this.getYarnExtFactor() + ", yarnAttnFactor=" + this.getYarnAttnFactor() + ", yarnBetaFast=" + this.getYarnBetaFast() + ", yarnBetaSlow=" + this.getYarnBetaSlow() + ", yarnOrigCtx=" + this.getYarnOrigCtx() + ", offloadKqv=" + this.isOffloadKqv() + ", splitMode=" + this.getSplitMode() + ", doPooling=" + this.isDoPooling() + ")";
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    public static class ModelParameterBuilder {
        private String modelPath;
        private String modelName;
        private boolean modelType$set;
        private String modelType$value;
        private boolean contextSize$set;
        private int contextSize$value;
        private Integer mainGpu;
        private boolean gpuLayers$set;
        private int gpuLayers$value;
        private boolean seed$set;
        private int seed$value;
        private boolean logitsAll$set;
        private boolean logitsAll$value;
        private boolean vocabOnly$set;
        private boolean vocabOnly$value;
        private boolean mmap$set;
        private boolean mmap$value;
        private boolean mlock$set;
        private boolean mlock$value;
        private boolean embedding$set;
        private boolean embedding$value;
        private boolean threads$set;
        private int threads$value;
        private boolean threadsBatch$set;
        private int threadsBatch$value;
        private boolean batchSize$set;
        private int batchSize$value;
        private String loraBase;
        private String loraPath;
        private float loraScale;
        private float[] tensorSplit;
        private boolean ropeFreqBase$set;
        private float ropeFreqBase$value;
        private boolean ropeFreqScale$set;
        private float ropeFreqScale$value;
        private Integer gqa;
        private Float rmsNormEps;
        private boolean mulMatQ$set;
        private boolean mulMatQ$value;
        private boolean verbose$set;
        private boolean verbose$value;
        private boolean ropeScalingType$set;
        private int ropeScalingType$value;
        private boolean yarnExtFactor$set;
        private float yarnExtFactor$value;
        private boolean yarnAttnFactor$set;
        private float yarnAttnFactor$value;
        private boolean yarnBetaFast$set;
        private float yarnBetaFast$value;
        private boolean yarnBetaSlow$set;
        private float yarnBetaSlow$value;
        private int yarnOrigCtx;
        private boolean offloadKqv$set;
        private boolean offloadKqv$value;
        private boolean splitMode$set;
        private int splitMode$value;
        private boolean doPooling$set;
        private boolean doPooling$value;

        ModelParameterBuilder() {
        }

        public ModelParameterBuilder modelPath(String modelPath) {
            this.modelPath = modelPath;
            return this;
        }

        public ModelParameterBuilder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public ModelParameterBuilder modelType(String modelType) {
            this.modelType$value = modelType;
            this.modelType$set = true;
            return this;
        }

        public ModelParameterBuilder contextSize(int contextSize) {
            this.contextSize$value = contextSize;
            this.contextSize$set = true;
            return this;
        }

        public ModelParameterBuilder mainGpu(@Nullable Integer mainGpu) {
            this.mainGpu = mainGpu;
            return this;
        }

        public ModelParameterBuilder gpuLayers(int gpuLayers) {
            this.gpuLayers$value = gpuLayers;
            this.gpuLayers$set = true;
            return this;
        }

        public ModelParameterBuilder seed(int seed) {
            this.seed$value = seed;
            this.seed$set = true;
            return this;
        }

        public ModelParameterBuilder logitsAll(boolean logitsAll) {
            this.logitsAll$value = logitsAll;
            this.logitsAll$set = true;
            return this;
        }

        public ModelParameterBuilder vocabOnly(boolean vocabOnly) {
            this.vocabOnly$value = vocabOnly;
            this.vocabOnly$set = true;
            return this;
        }

        public ModelParameterBuilder mmap(boolean mmap) {
            this.mmap$value = mmap;
            this.mmap$set = true;
            return this;
        }

        public ModelParameterBuilder mlock(boolean mlock) {
            this.mlock$value = mlock;
            this.mlock$set = true;
            return this;
        }

        public ModelParameterBuilder embedding(boolean embedding) {
            this.embedding$value = embedding;
            this.embedding$set = true;
            return this;
        }

        public ModelParameterBuilder threads(int threads) {
            this.threads$value = threads;
            this.threads$set = true;
            return this;
        }

        public ModelParameterBuilder threadsBatch(int threadsBatch) {
            this.threadsBatch$value = threadsBatch;
            this.threadsBatch$set = true;
            return this;
        }

        public ModelParameterBuilder batchSize(int batchSize) {
            this.batchSize$value = batchSize;
            this.batchSize$set = true;
            return this;
        }

        public ModelParameterBuilder loraBase(@Nullable String loraBase) {
            this.loraBase = loraBase;
            return this;
        }

        public ModelParameterBuilder loraPath(@Nullable String loraPath) {
            this.loraPath = loraPath;
            return this;
        }

        public ModelParameterBuilder loraScale(float loraScale) {
            this.loraScale = loraScale;
            return this;
        }

        public ModelParameterBuilder tensorSplit(@Nullable float[] tensorSplit) {
            this.tensorSplit = tensorSplit;
            return this;
        }

        public ModelParameterBuilder ropeFreqBase(float ropeFreqBase) {
            this.ropeFreqBase$value = ropeFreqBase;
            this.ropeFreqBase$set = true;
            return this;
        }

        public ModelParameterBuilder ropeFreqScale(float ropeFreqScale) {
            this.ropeFreqScale$value = ropeFreqScale;
            this.ropeFreqScale$set = true;
            return this;
        }

        public ModelParameterBuilder gqa(@Nullable Integer gqa) {
            this.gqa = gqa;
            return this;
        }

        public ModelParameterBuilder rmsNormEps(@Nullable Float rmsNormEps) {
            this.rmsNormEps = rmsNormEps;
            return this;
        }

        public ModelParameterBuilder mulMatQ(boolean mulMatQ) {
            this.mulMatQ$value = mulMatQ;
            this.mulMatQ$set = true;
            return this;
        }

        public ModelParameterBuilder verbose(boolean verbose) {
            this.verbose$value = verbose;
            this.verbose$set = true;
            return this;
        }

        public ModelParameterBuilder ropeScalingType(int ropeScalingType) {
            this.ropeScalingType$value = ropeScalingType;
            this.ropeScalingType$set = true;
            return this;
        }

        public ModelParameterBuilder yarnExtFactor(float yarnExtFactor) {
            this.yarnExtFactor$value = yarnExtFactor;
            this.yarnExtFactor$set = true;
            return this;
        }

        public ModelParameterBuilder yarnAttnFactor(float yarnAttnFactor) {
            this.yarnAttnFactor$value = yarnAttnFactor;
            this.yarnAttnFactor$set = true;
            return this;
        }

        public ModelParameterBuilder yarnBetaFast(float yarnBetaFast) {
            this.yarnBetaFast$value = yarnBetaFast;
            this.yarnBetaFast$set = true;
            return this;
        }

        public ModelParameterBuilder yarnBetaSlow(float yarnBetaSlow) {
            this.yarnBetaSlow$value = yarnBetaSlow;
            this.yarnBetaSlow$set = true;
            return this;
        }

        public ModelParameterBuilder yarnOrigCtx(int yarnOrigCtx) {
            this.yarnOrigCtx = yarnOrigCtx;
            return this;
        }

        public ModelParameterBuilder offloadKqv(boolean offloadKqv) {
            this.offloadKqv$value = offloadKqv;
            this.offloadKqv$set = true;
            return this;
        }

        public ModelParameterBuilder splitMode(int splitMode) {
            this.splitMode$value = splitMode;
            this.splitMode$set = true;
            return this;
        }

        public ModelParameterBuilder doPooling(boolean doPooling) {
            this.doPooling$value = doPooling;
            this.doPooling$set = true;
            return this;
        }

        public ModelParameter build() {
            String modelType$value = this.modelType$value;
            if (!this.modelType$set) {
                modelType$value = ModelParameter.$default$modelType();
            }
            int contextSize$value = this.contextSize$value;
            if (!this.contextSize$set) {
                contextSize$value = ModelParameter.$default$contextSize();
            }
            int gpuLayers$value = this.gpuLayers$value;
            if (!this.gpuLayers$set) {
                gpuLayers$value = ModelParameter.$default$gpuLayers();
            }
            int seed$value = this.seed$value;
            if (!this.seed$set) {
                seed$value = ModelParameter.$default$seed();
            }
            boolean logitsAll$value = this.logitsAll$value;
            if (!this.logitsAll$set) {
                logitsAll$value = ModelParameter.$default$logitsAll();
            }
            boolean vocabOnly$value = this.vocabOnly$value;
            if (!this.vocabOnly$set) {
                vocabOnly$value = ModelParameter.$default$vocabOnly();
            }
            boolean mmap$value = this.mmap$value;
            if (!this.mmap$set) {
                mmap$value = ModelParameter.$default$mmap();
            }
            boolean mlock$value = this.mlock$value;
            if (!this.mlock$set) {
                mlock$value = ModelParameter.$default$mlock();
            }
            boolean embedding$value = this.embedding$value;
            if (!this.embedding$set) {
                embedding$value = ModelParameter.$default$embedding();
            }
            int threads$value = this.threads$value;
            if (!this.threads$set) {
                threads$value = ModelParameter.$default$threads();
            }
            int threadsBatch$value = this.threadsBatch$value;
            if (!this.threadsBatch$set) {
                threadsBatch$value = ModelParameter.$default$threadsBatch();
            }
            int batchSize$value = this.batchSize$value;
            if (!this.batchSize$set) {
                batchSize$value = ModelParameter.$default$batchSize();
            }
            float ropeFreqBase$value = this.ropeFreqBase$value;
            if (!this.ropeFreqBase$set) {
                ropeFreqBase$value = ModelParameter.$default$ropeFreqBase();
            }
            float ropeFreqScale$value = this.ropeFreqScale$value;
            if (!this.ropeFreqScale$set) {
                ropeFreqScale$value = ModelParameter.$default$ropeFreqScale();
            }
            boolean mulMatQ$value = this.mulMatQ$value;
            if (!this.mulMatQ$set) {
                mulMatQ$value = ModelParameter.$default$mulMatQ();
            }
            boolean verbose$value = this.verbose$value;
            if (!this.verbose$set) {
                verbose$value = ModelParameter.$default$verbose();
            }
            int ropeScalingType$value = this.ropeScalingType$value;
            if (!this.ropeScalingType$set) {
                ropeScalingType$value = ModelParameter.$default$ropeScalingType();
            }
            float yarnExtFactor$value = this.yarnExtFactor$value;
            if (!this.yarnExtFactor$set) {
                yarnExtFactor$value = ModelParameter.$default$yarnExtFactor();
            }
            float yarnAttnFactor$value = this.yarnAttnFactor$value;
            if (!this.yarnAttnFactor$set) {
                yarnAttnFactor$value = ModelParameter.$default$yarnAttnFactor();
            }
            float yarnBetaFast$value = this.yarnBetaFast$value;
            if (!this.yarnBetaFast$set) {
                yarnBetaFast$value = ModelParameter.$default$yarnBetaFast();
            }
            float yarnBetaSlow$value = this.yarnBetaSlow$value;
            if (!this.yarnBetaSlow$set) {
                yarnBetaSlow$value = ModelParameter.$default$yarnBetaSlow();
            }
            boolean offloadKqv$value = this.offloadKqv$value;
            if (!this.offloadKqv$set) {
                offloadKqv$value = ModelParameter.$default$offloadKqv();
            }
            int splitMode$value = this.splitMode$value;
            if (!this.splitMode$set) {
                splitMode$value = ModelParameter.$default$splitMode();
            }
            boolean doPooling$value = this.doPooling$value;
            if (!this.doPooling$set) {
                doPooling$value = ModelParameter.$default$doPooling();
            }
            return new ModelParameter(this.modelPath, this.modelName, modelType$value, contextSize$value, this.mainGpu, gpuLayers$value, seed$value, logitsAll$value, vocabOnly$value, mmap$value, mlock$value, embedding$value, threads$value, threadsBatch$value, batchSize$value, this.loraBase, this.loraPath, this.loraScale, this.tensorSplit, ropeFreqBase$value, ropeFreqScale$value, this.gqa, this.rmsNormEps, mulMatQ$value, verbose$value, ropeScalingType$value, yarnExtFactor$value, yarnAttnFactor$value, yarnBetaFast$value, yarnBetaSlow$value, this.yarnOrigCtx, offloadKqv$value, splitMode$value, doPooling$value);
        }

        public String toString() {
            return "ModelParameter.ModelParameterBuilder(modelPath=" + this.modelPath + ", modelName=" + this.modelName + ", modelType$value=" + this.modelType$value + ", contextSize$value=" + this.contextSize$value + ", mainGpu=" + this.mainGpu + ", gpuLayers$value=" + this.gpuLayers$value + ", seed$value=" + this.seed$value + ", logitsAll$value=" + this.logitsAll$value + ", vocabOnly$value=" + this.vocabOnly$value + ", mmap$value=" + this.mmap$value + ", mlock$value=" + this.mlock$value + ", embedding$value=" + this.embedding$value + ", threads$value=" + this.threads$value + ", threadsBatch$value=" + this.threadsBatch$value + ", batchSize$value=" + this.batchSize$value + ", loraBase=" + this.loraBase + ", loraPath=" + this.loraPath + ", loraScale=" + this.loraScale + ", tensorSplit=" + Arrays.toString(this.tensorSplit) + ", ropeFreqBase$value=" + this.ropeFreqBase$value + ", ropeFreqScale$value=" + this.ropeFreqScale$value + ", gqa=" + this.gqa + ", rmsNormEps=" + this.rmsNormEps + ", mulMatQ$value=" + this.mulMatQ$value + ", verbose$value=" + this.verbose$value + ", ropeScalingType$value=" + this.ropeScalingType$value + ", yarnExtFactor$value=" + this.yarnExtFactor$value + ", yarnAttnFactor$value=" + this.yarnAttnFactor$value + ", yarnBetaFast$value=" + this.yarnBetaFast$value + ", yarnBetaSlow$value=" + this.yarnBetaSlow$value + ", yarnOrigCtx=" + this.yarnOrigCtx + ", offloadKqv$value=" + this.offloadKqv$value + ", splitMode$value=" + this.splitMode$value + ", doPooling$value=" + this.doPooling$value + ")";
        }
    }
}

