/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model.utils;

import chat.octet.model.enums.ModelType;
import com.google.common.base.Preconditions;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;

public class PromptBuilder {
    public static final String DEFAULT_ALPACA_SYSTEM = "Below is an instruction that describes a task. Write a response that appropriately completes the request.";
    public static final String DEFAULT_COMMON_SYSTEM = "You are a helpful, respectful and honest assistant. Always answer as helpfully as possible, while being safe.  Your answers should not include any harmful, unethical, racist, sexist, toxic, dangerous, or illegal content. Please ensure that your responses are socially unbiased and positive in nature.\nIf a question does not make any sense, or is not factually coherent, explain why instead of answering something not correct. If you don't know the answer to a question, please don't share false information.";

    private PromptBuilder() {
    }

    public static String format(ModelType modelType, String question) {
        return PromptBuilder.format(modelType, null, question);
    }

    public static String format(ModelType modelType, String system, String question) {
        Preconditions.checkNotNull((Object)question, (Object)"User question cannot be null");
        String formatSystem = "";
        if (StringUtils.isNotBlank((CharSequence)system)) {
            formatSystem = StringUtils.isNotBlank((CharSequence)modelType.getSystemTemplate()) ? MessageFormat.format(modelType.getSystemTemplate(), system) + "\n" : system + "\n";
        }
        return MessageFormat.format(modelType.getPromptTemplate(), formatSystem, question);
    }
}

