/*
 * ------------------------------------------------------------------------
 * TamTam chat Bot API
 * ------------------------------------------------------------------------
 * Copyright (C) 2018 Mail.Ru Group
 * ------------------------------------------------------------------------
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ------------------------------------------------------------------------
 */

package chat.tamtam.botapi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;


/**
 * PhotoAttachmentPayload
 */
public class PhotoAttachmentPayload implements TamTamSerializable {

    private final Long photoId;
    private final String token;
    private final String url;

    @JsonCreator
    public PhotoAttachmentPayload(@JsonProperty("photo_id") Long photoId, @JsonProperty("token") String token, @JsonProperty("url") String url) { 
        this.photoId = photoId;
        this.token = token;
        this.url = url;
    }

    /**
    * Unique identifier of this image
    * @return photoId
    **/
    @JsonProperty("photo_id")
    public Long getPhotoId() {
        return photoId;
    }

    /**
    * @return token
    **/
    @JsonProperty("token")
    public String getToken() {
        return token;
    }

    /**
    * Image URL
    * @return url
    **/
    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
          return true;
        }
        if (o == null || getClass() != o.getClass()) {
          return false;
        }

        PhotoAttachmentPayload other = (PhotoAttachmentPayload) o;
        return Objects.equals(this.photoId, other.photoId) &&
            Objects.equals(this.token, other.token) &&
            Objects.equals(this.url, other.url);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (photoId != null ? photoId.hashCode() : 0);
        result = 31 * result + (token != null ? token.hashCode() : 0);
        result = 31 * result + (url != null ? url.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "PhotoAttachmentPayload{"
            + " photoId='" + photoId + '\''
            + " token='" + token + '\''
            + " url='" + url + '\''
            + '}';
    }
}
