/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.support.redis;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.support.DomainDataStorageAccess;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.cache.RedisCache;

public class StorageAccessImpl
implements DomainDataStorageAccess {
    private final Logger logger = LoggerFactory.getLogger(StorageAccessImpl.class);
    private final RedisCache cache;

    StorageAccessImpl(RedisCache cache) {
        this.cache = cache;
    }

    public RedisCache getCache() {
        return this.cache;
    }

    public Object getFromCache(Object key, SharedSessionContractImplementor session) {
        try {
            Cache.ValueWrapper element = this.getCache().get(key);
            if (element == null) {
                return null;
            }
            return element.get();
        }
        catch (RedisConnectionFailureException e) {
            this.logger.error("\u8fde\u63a5Redis\u5931\u8d25", (Throwable)e);
            throw new CacheException((Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("redis\u7f13\u5b58\u63d0\u53d6\u5931\u8d25", (Throwable)e);
            throw new CacheException((Throwable)e);
        }
    }

    public void putIntoCache(Object key, Object value, SharedSessionContractImplementor session) {
        try {
            this.getCache().put(key, value);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw new CacheException((Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("redis\u7f13\u5b58\u5b58\u653e\u5931\u8d25", (Throwable)e);
            throw new CacheException((Throwable)e);
        }
    }

    public boolean contains(Object key) {
        return this.getCache().get(key) != null;
    }

    public void evictData() {
        try {
            this.getCache().clear();
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("redis\u7f13\u5b58\u6e05\u7a7a\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void evictData(Object key) {
        try {
            this.getCache().get(key);
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("redis\u7f13\u5b58\u5220\u9664\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void release() {
        try {
            this.getCache().clear();
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                if (e instanceof RedisConnectionFailureException) {
                    this.logger.error("redis\u8fde\u63a5\u5931\u8d25", (Throwable)e);
                } else {
                    this.logger.error("redis\u7f13\u5b58\u5220\u9664\u6570\u636e\u5931\u8d25", (Throwable)e);
                }
            }
            throw new CacheException((Throwable)e);
        }
    }
}

