package cloud.agileframework.cache.support.redis;

import com.alibaba.fastjson2.support.spring.data.redis.GenericFastJsonRedisSerializer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

/**
 * @author 佟盟
 * 日期 2021-03-30 16:18
 * 描述 redis序列化工具
 * @version 1.0
 * @since 1.0
 */
@Slf4j
public class GenericRedisSerializer implements RedisSerializer<Object>, SecondCacheSerializerProvider {

    private static final GenericFastJsonRedisSerializer FAST_JSON_REDIS_SERIALIZER = new GenericFastJsonRedisSerializer();

    @Override
    public byte[] serialize(Object object) throws SerializationException {
        byte[] result = new byte[0];
        if (object == null) {
            return result;
        }
        

        return FAST_JSON_REDIS_SERIALIZER.serialize(object);
    }

    @Override
    public Object deserialize(byte[] bytes) throws SerializationException {

        if (bytes == null || bytes.length == 0) {
            return null;
        }

        return FAST_JSON_REDIS_SERIALIZER.deserialize(bytes);
    }
}
