/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.config;

import cloud.agileframework.cache.config.CacheAutoConfiguration;
import cloud.agileframework.cache.support.redis.AgileRedisCacheManager;
import cloud.agileframework.cache.support.redis.GenericRedisSerializer;
import cloud.agileframework.cache.support.redis.Jackson2ModuleProvider;
import cloud.agileframework.cache.support.redis.SecondCacheSerializerProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
@ConditionalOnClass(value={RedisCacheManager.class})
public class RedisAutoConfiguration
implements CacheAutoConfiguration {
    @Bean
    public AgileRedisCacheManager agileRedisCacheManager(RedisCacheManager redisCacheManager, RedisConnectionFactory redisConnectionFactory) {
        return new AgileRedisCacheManager(redisCacheManager, redisConnectionFactory);
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisCacheManager.class})
    public RedisCacheManager redisCacheManager(RedisConnectionFactory redisConnectionFactory) {
        return RedisCacheManager.create((RedisConnectionFactory)redisConnectionFactory);
    }

    @Bean
    @ConditionalOnMissingBean(value={SecondCacheSerializerProvider.class})
    public SecondCacheSerializerProvider secondCacheSerializerProvider(ObjectProvider<Jackson2ModuleProvider> jackson2ModuleProviders) {
        return new GenericRedisSerializer();
    }
}

