/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.support.ehcache;

import cloud.agileframework.cache.support.AbstractAgileCache;
import cloud.agileframework.cache.support.ehcache.TransmitKey;
import cloud.agileframework.cache.sync.OpType;
import cloud.agileframework.cache.sync.SyncCache;
import cloud.agileframework.cache.sync.SyncKeys;
import cloud.agileframework.cache.util.BeanUtil;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.springframework.cache.Cache;
import org.springframework.cache.ehcache.EhCacheCache;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.NumberUtils;

public class AgileEhCache
extends AbstractAgileCache {
    private static final AntPathMatcher ANT = new AntPathMatcher();
    private final Ehcache nativeCache;

    AgileEhCache(EhCacheCache cache) {
        super((Cache)cache);
        this.nativeCache = cache.getNativeCache();
    }

    public boolean evictIfPresent(Object key) {
        return super.evictIfPresent((Object)TransmitKey.of(key));
    }

    @Override
    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        return super.putIfAbsent(TransmitKey.of(key), value);
    }

    @Override
    public void evict(Object key) {
        super.evict(TransmitKey.of(key));
    }

    public Ehcache getNativeCache() {
        return this.nativeCache;
    }

    private SyncCache syncCache() {
        return (SyncCache)BeanUtil.getApplicationContext().getBean(SyncCache.class);
    }

    @Override
    public <T> T get(Object key, Class<T> clazz) {
        return (T)this.syncCache().sync(SyncKeys.of(this.getName(), key), () -> {
            Cache.ValueWrapper v = super.get(TransmitKey.of(key));
            if (v == null) {
                return null;
            }
            Object o = v.get();
            if (o == null) {
                return null;
            }
            return ObjectUtil.to((Object)o, (TypeReference)new TypeReference((Type)clazz));
        }, OpType.READ);
    }

    @Override
    public Cache.ValueWrapper get(Object key) {
        return this.syncCache().sync(SyncKeys.of(this.getName(), key), () -> super.get(TransmitKey.of(key)), OpType.READ);
    }

    @Override
    public <T> T get(Object key, Callable<T> valueLoader) {
        return (T)this.syncCache().sync(SyncKeys.of(this.getName(), key), () -> super.get((Object)TransmitKey.of(key), valueLoader), OpType.READ);
    }

    @Override
    public <T> T get(Object key, TypeReference<T> typeReference) {
        return (T)this.syncCache().sync(SyncKeys.of(this.getName(), key), () -> {
            Cache.ValueWrapper wrapper = super.get(TransmitKey.of(key));
            if (wrapper != null) {
                Object v = wrapper.get();
                return ObjectUtil.to((Object)v, (TypeReference)typeReference);
            }
            return null;
        }, OpType.READ);
    }

    @Override
    public void put(Object key, Object value, Duration timeout) {
        this.directPut(TransmitKey.of(key), value, timeout);
    }

    @Override
    public void put(Object key, Object value) {
        this.directPut(TransmitKey.of(key), value);
    }

    @Override
    public boolean containKey(Object key) {
        return this.syncCache().sync(SyncKeys.of(this.getName(), key), () -> this.nativeCache.isKeyInCache((Object)TransmitKey.of(key)), OpType.READ);
    }

    @Override
    public void addToMap(Object mapKey, Object key, Object value) {
        Map<Object, Object> map = this.directGetMap(mapKey);
        map.put(key, value);
        this.directPut(TransmitKey.of(mapKey), map);
    }

    @Override
    public Object getFromMap(Object mapKey, Object key) {
        return this.syncCache().sync(SyncKeys.of(this.getName(), mapKey), () -> {
            Map<Object, Object> map = this.directGetMap(mapKey);
            return map.get(key);
        }, OpType.READ);
    }

    @Override
    public <T> T getFromMap(Object mapKey, Object key, Class<T> clazz) {
        return (T)this.syncCache().sync(SyncKeys.of(this.getName(), mapKey), () -> {
            Map<Object, Object> map = this.directGetMap(mapKey);
            Object value = map.get(key);
            return ObjectUtil.to((Object)value, (TypeReference)new TypeReference((Type)clazz));
        }, OpType.READ);
    }

    @Override
    public void removeFromMap(Object mapKey, Object key) {
        Map<Object, Object> map = this.directGetMap(mapKey);
        if (map.containsKey(key)) {
            map.remove(key);
            this.directPut(TransmitKey.of(mapKey), map);
        }
    }

    @Override
    public void addToList(Object listKey, Object node) {
        List<Object> list = this.directGetList(listKey);
        list.add(node);
        this.directPut(TransmitKey.of(listKey), list);
    }

    @Override
    public Object getFromList(Object listKey, int index) {
        return this.syncCache().sync(SyncKeys.of(this.getName(), listKey), () -> {
            List<Object> list = this.directGetList(listKey);
            if (list.size() >= index) {
                return list.get(index);
            }
            return null;
        }, OpType.READ);
    }

    @Override
    public <T> T getFromList(Object listKey, int index, Class<T> clazz) {
        return (T)this.syncCache().sync(SyncKeys.of(this.getName(), listKey), () -> {
            List<Object> list = this.directGetList(listKey);
            Object value = null;
            if (list.size() >= index) {
                value = list.get(index);
            }
            return ObjectUtil.to((Object)value, (TypeReference)new TypeReference((Type)clazz));
        }, OpType.READ);
    }

    @Override
    public void removeFromList(Object listKey, int index) {
        List<Object> list = this.directGetList(listKey);
        if (list.size() >= index) {
            list.remove(index);
            this.directPut(TransmitKey.of(listKey), list);
        }
    }

    @Override
    public void addToSet(Object setKey, Object node) {
        Set<Object> set = this.directGetSet(setKey);
        set.add(node);
        this.directPut(TransmitKey.of(setKey), set);
    }

    @Override
    public void removeFromSet(Object setKey, Object node) {
        Set<Object> set = this.directGetSet(setKey);
        if (set.remove(node)) {
            this.directPut(TransmitKey.of(setKey), set);
        }
    }

    @Override
    public boolean connectKey(Object setKey, Object node) {
        Set<Object> set = this.directGetSet(setKey);
        return set.contains(node);
    }

    @Override
    public synchronized boolean lock(Object lock) {
        boolean isLock;
        try {
            isLock = this.nativeCache.tryWriteLockOnKey((Object)TransmitKey.of(lock), 1L);
        }
        catch (InterruptedException e) {
            isLock = false;
            Thread.currentThread().interrupt();
        }
        return isLock;
    }

    @Override
    public void unlock(Object lock) {
        this.nativeCache.releaseWriteLockOnKey((Object)TransmitKey.of(lock));
    }

    @Override
    public List<String> keys(Object key) {
        return this.syncCache().sync(SyncKeys.of(this.getName(), key), () -> {
            String pattern = String.valueOf(key);
            List keys = this.nativeCache.getKeys();
            return keys.stream().map(a -> {
                if (a instanceof TransmitKey) {
                    return ObjectUtil.toString((Object)((TransmitKey)a).getKey());
                }
                return ObjectUtil.toString((Object)a);
            }).filter(b -> ANT.match(pattern, b)).collect(Collectors.toList());
        }, OpType.READ);
    }

    public void directPut(Object key, Object value, Duration timeout) {
        if (!(key instanceof TransmitKey)) {
            key = TransmitKey.of(key, false);
        }
        Element element = new Element(key, (Object)SerializationUtils.clone((Serializable)((Serializable)value)));
        element.setTimeToLive(((Integer)NumberUtils.parseNumber((String)Long.toString(timeout.getSeconds()), Integer.class)).intValue());
        element.setTimeToIdle(((Integer)NumberUtils.parseNumber((String)Long.toString(timeout.getSeconds()), Integer.class)).intValue());
        element.setEternal(false);
        Element old = this.nativeCache.get(key);
        if (old == null) {
            this.nativeCache.put(element);
        } else {
            this.nativeCache.replace(old, element);
        }
    }

    public void directPut(Object key, Object value) {
        if (!(key instanceof TransmitKey)) {
            key = TransmitKey.of(key, false);
        }
        long randomRange = RandomUtils.nextLong((long)1680000L, (long)1920000L);
        Duration timeout = Duration.ofMillis(randomRange);
        Ehcache ehCache = this.nativeCache;
        Element element = new Element(key, (Object)SerializationUtils.clone((Serializable)((Serializable)value)));
        element.setTimeToIdle(((Integer)NumberUtils.parseNumber((String)Long.toString(timeout.getSeconds()), Integer.class)).intValue());
        element.setEternal(false);
        Element old = ehCache.get(key);
        if (old == null) {
            ehCache.put(element);
        } else {
            ehCache.replace(old, element);
        }
    }

    public void directEvict(Object key) {
        if (!(key instanceof TransmitKey)) {
            key = TransmitKey.of(key, false);
        }
        super.evict(key);
    }

    private Map<Object, Object> directGetMap(Object mapKey) {
        Map map = this.get(mapKey, Map.class);
        if (map == null) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        return map;
    }

    private List<Object> directGetList(Object listKey) {
        List list = this.get(listKey, List.class);
        if (list == null) {
            return Lists.newArrayList();
        }
        return list;
    }

    private Set<Object> directGetSet(Object setKey) {
        Set set = this.get(setKey, Set.class);
        if (set == null) {
            return Sets.newHashSet();
        }
        return set;
    }
}

