/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.cache.sync;

import cloud.agileframework.cache.support.ehcache.AgileEhCache;
import cloud.agileframework.cache.support.ehcache.AgileEhCacheCacheManager;
import cloud.agileframework.cache.support.ehcache.TransmitKey;
import cloud.agileframework.cache.support.redis.AgileRedis;
import cloud.agileframework.cache.support.redis.AgileRedisCacheManager;
import cloud.agileframework.cache.sync.AsyncManager;
import cloud.agileframework.cache.sync.CacheSyncException;
import cloud.agileframework.cache.sync.OpType;
import cloud.agileframework.cache.sync.OptimisticLockCheckError;
import cloud.agileframework.cache.sync.SyncCache;
import cloud.agileframework.cache.sync.SyncKeys;
import cloud.agileframework.common.util.clazz.TypeReference;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisSyncCache
implements MessageListener,
SyncCache {
    public static final String LOCK_CACHE_KEY = "key";
    @Autowired
    private AgileRedisCacheManager agileRedisCacheManager;
    @Autowired
    private AgileEhCacheCacheManager agileEhCacheCacheManager;
    @Autowired
    private StringRedisTemplate redisTemplate;

    private void notice(String channel, int newCacheVersion) {
        this.redisTemplate.convertAndSend(channel, (Object)Integer.toString(newCacheVersion));
    }

    public void onMessage(Message message, byte[] pattern) {
        Object channel = this.redisTemplate.getKeySerializer().deserialize(message.getChannel());
        Object noticeVersionData = this.redisTemplate.getValueSerializer().deserialize(message.getBody());
        if (noticeVersionData instanceof String && NumberUtils.isCreatable((String)((String)noticeVersionData))) {
            this.message((String)channel, NumberUtils.toInt((String)((String)noticeVersionData)));
            return;
        }
        throw new CacheSyncException("Notification content does not conform to version number format");
    }

    private void ehcacheToRedis(SyncKeys syncKeys, OpType opType) {
        AgileRedis redisCache = this.agileRedisCacheManager.getCache(syncKeys.getRegion());
        if (OpType.DELETE == opType) {
            syncKeys.getVersionData().set(-1);
            redisCache.evict(syncKeys.getData());
            redisCache.evict(syncKeys.getVersion());
        } else if (OpType.WRITE == opType) {
            Element element = this.agileEhCacheCacheManager.getCache(syncKeys.getRegion()).getNativeCache().get((Object)TransmitKey.of(syncKeys.getData()));
            if (element == null || element.getObjectValue() == null) {
                return;
            }
            syncKeys.getVersionData().addAndGet(1);
            if (syncKeys.getTimeout().isZero()) {
                redisCache.put(syncKeys.getData(), element.getObjectValue());
                redisCache.put(syncKeys.getVersion(), syncKeys.getVersionData().get());
            } else {
                Duration timeout = syncKeys.getTimeout();
                redisCache.put(syncKeys.getData(), element.getObjectValue(), timeout);
                redisCache.put(syncKeys.getVersion(), syncKeys.getVersionData().get(), timeout);
            }
        }
    }

    private void redisToEhcache(SyncKeys syncKeys, OpType opType) {
        AgileEhCache ehcache = this.agileEhCacheCacheManager.getCache(syncKeys.getRegion());
        String dataKey = syncKeys.getData();
        if (OpType.DELETE == opType) {
            ehcache.directEvict(dataKey);
        } else if (OpType.READ == opType || OpType.WRITE == opType) {
            AgileRedis redisCache = this.agileRedisCacheManager.getCache(syncKeys.getRegion());
            Long timeout = redisCache.getTimeout(dataKey);
            if (timeout == 0L || timeout < -1L) {
                return;
            }
            Object value = null;
            DataType dataType = redisCache.typeKey(dataKey);
            switch (dataType) {
                case SET: 
                case ZSET: {
                    value = redisCache.get((Object)dataKey, new TypeReference(Set.class));
                    break;
                }
                case HASH: {
                    value = redisCache.get((Object)dataKey, new TypeReference(Map.class));
                    break;
                }
                case LIST: {
                    value = redisCache.get((Object)dataKey, new TypeReference(List.class));
                    break;
                }
                case STRING: {
                    value = redisCache.get((Object)dataKey, new TypeReference(String.class));
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    Optional.ofNullable(redisCache.get(dataKey)).orElse((Cache.ValueWrapper)new SimpleValueWrapper(null)).get();
                }
            }
            if (value == null) {
                return;
            }
            if (timeout > 0L) {
                ehcache.directPut(dataKey, value, Duration.ofSeconds(timeout));
            } else {
                ehcache.directPut(dataKey, value);
            }
            this.syncVersion(syncKeys);
        }
    }

    private void syncVersion(SyncKeys syncKeys) {
        AgileRedis redisCache = this.agileRedisCacheManager.getCache(syncKeys.getRegion());
        Integer cacheVersion = redisCache.get((Object)syncKeys.getVersion(), Integer.class);
        if (cacheVersion != null) {
            syncKeys.getVersionData().set(cacheVersion);
        }
    }

    public void message(String channel, int noticeVersion) {
        AgileRedis redisCache = this.agileRedisCacheManager.getCache(channel);
        SyncKeys syncKeys = SyncKeys.of(channel);
        Integer cacheVersionData = (Integer)redisCache.get(syncKeys.getVersion(), Integer.class);
        if (cacheVersionData == null) {
            throw new CacheSyncException("The cached version number was not found");
        }
        int cacheVersion = NumberUtils.toInt((String)cacheVersionData.toString());
        if (-1 == noticeVersion) {
            this.redisToEhcache(syncKeys, OpType.DELETE);
        } else {
            if (cacheVersion < noticeVersion) {
                throw new CacheSyncException("The version number of the notification does not match the version number of the cache");
            }
            this.redisToEhcache(syncKeys, OpType.WRITE);
        }
    }

    private boolean writeLock(SyncKeys syncKeys) {
        AgileRedis redisCache = this.agileRedisCacheManager.getCache(LOCK_CACHE_KEY);
        if (redisCache.containLock(syncKeys.getReadLock())) {
            return false;
        }
        return redisCache.lockOnThreadLocal(syncKeys.getWriteLock(), Duration.ofSeconds(120L));
    }

    private boolean readLock(SyncKeys syncKeys) {
        AgileRedis redisCache = this.agileRedisCacheManager.getCache(LOCK_CACHE_KEY);
        if (redisCache.containLock(syncKeys.getWriteLock())) {
            return true;
        }
        return redisCache.lockOnThreadLocal(syncKeys.getReadLock(), Duration.ofSeconds(120L));
    }

    private void unlock(String lockKey) {
        AgileRedis redisCache = this.agileRedisCacheManager.getCache(LOCK_CACHE_KEY);
        redisCache.unlock(lockKey);
    }

    @Override
    public <T> T sync(SyncKeys syncKeys, Supplier<T> supplier, OpType opType) {
        T result = null;
        for (int count = 100; count > 0; --count) {
            switch (opType) {
                case READ: {
                    T v = supplier.get();
                    if (v != null) {
                        return v;
                    }
                    if (!this.syncData(syncKeys)) break;
                    return supplier.get();
                }
            }
            try {
                Thread.sleep(Duration.ofMillis(10L).toMillis());
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
        return result;
    }

    @Override
    public void sync(SyncKeys syncKeys, OpType opType) {
        if (opType != OpType.WRITE && opType != OpType.DELETE) {
            return;
        }
        for (int count = 100; count > 0; --count) {
            switch (opType) {
                case WRITE: 
                case DELETE: {
                    if (!this.writeLock(syncKeys)) break;
                    try {
                        AsyncManager.execute(() -> this.ehcacheToRedisAndNotice(syncKeys, opType));
                        return;
                    }
                    catch (OptimisticLockCheckError e) {
                        this.unlock(syncKeys.getWriteLock());
                        throw e;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.unlock(syncKeys.getWriteLock());
                        break;
                    }
                }
            }
            try {
                Thread.sleep(Duration.ofMillis(10L).toMillis());
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void clear(String region) {
        Ehcache ehcache = this.agileEhCacheCacheManager.getCache(region).getNativeCache();
        List keys = ehcache.getKeys();
        keys.forEach(key -> this.sync(SyncKeys.of(region, key), () -> null, OpType.DELETE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void ehcacheToRedisAndNotice(SyncKeys syncKeys, OpType opType) {
        try {
            this.ehcacheToRedis(syncKeys, opType);
            this.notice(syncKeys.getChannel(), syncKeys.getVersionData().get());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.unlock(syncKeys.getWriteLock());
        }
        if (OpType.DELETE == opType) {
            SyncKeys.remove(syncKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean syncData(SyncKeys syncKeys) {
        if (this.readLock(syncKeys)) {
            try {
                this.redisToEhcache(syncKeys, OpType.READ);
            }
            catch (Exception e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                this.unlock(syncKeys.getReadLock());
            }
            return true;
        }
        return false;
    }
}

