/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.dictionary;

import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.dictionary.DictionaryDataBase;
import cloud.agileframework.dictionary.DictionaryDataManager;
import cloud.agileframework.dictionary.cache.NotFoundCacheException;
import cloud.agileframework.dictionary.cache.RegionEnum;
import cloud.agileframework.dictionary.util.DictionaryUtil;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AbstractDictionaryDataManager<D extends DictionaryDataBase>
implements DictionaryDataManager<D> {
    public SyncProxy sync() {
        return new SyncProxy();
    }

    D findOne(String id) {
        try {
            return (D)((Object)this.cache().getByFullIndex(this.dataSource(), RegionEnum.ID_MEMORY, id));
        }
        catch (NotFoundCacheException e) {
            e.printStackTrace();
            return null;
        }
    }

    public class SyncProxy {
        public SortedSet<D> all() {
            SortedSet<DictionaryDataBase> treeSet = DictionaryUtil.findAll(AbstractDictionaryDataManager.this.dataSource());
            return treeSet;
        }

        public SortedSet<D> tree() {
            String root = AbstractDictionaryDataManager.this.rootParentId();
            return this.all().stream().filter(dic -> Objects.equals(dic.getParentId(), root)).collect(Collectors.toCollection(ConcurrentSkipListSet::new));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(D dictionaryData) {
            SyncProxy syncProxy = this;
            synchronized (syncProxy) {
                if (((DictionaryDataBase)((Object)dictionaryData)).getId() != null && Objects.equals(((DictionaryDataBase)((Object)dictionaryData)).getId(), ((DictionaryDataBase)((Object)dictionaryData)).getParentId())) {
                    throw new IllegalArgumentException("\u7236\u4e3b\u952e\u4e0e\u4e3b\u952e\u4e0d\u80fd\u76f8\u540c");
                }
                this.addData(dictionaryData);
                AbstractDictionaryDataManager.this.cache().refresh(AbstractDictionaryDataManager.this.dataSource());
            }
        }

        private void addData(D dictionaryData) {
            Object self = AbstractDictionaryDataManager.this.findOne(((DictionaryDataBase)((Object)dictionaryData)).getId());
            if (self != null) {
                this.updateData(dictionaryData, AbstractDictionaryDataManager.this::update, false, false);
                return;
            }
            AbstractDictionaryDataManager.this.add(dictionaryData);
            this.addCache(dictionaryData);
            Optional.ofNullable(dictionaryData.getChildren()).ifPresent(children -> children.stream().map(a -> a).forEach(this::addData));
        }

        private void addCache(D dictionaryData) {
            Object parent = AbstractDictionaryDataManager.this.findOne(((DictionaryDataBase)((Object)dictionaryData)).getParentId());
            if (parent != null) {
                ((DictionaryDataBase)((Object)dictionaryData)).setFullCode(((DictionaryDataBase)((Object)parent)).getFullCode() + "$$" + ((DictionaryDataBase)((Object)dictionaryData)).getCode());
                ((DictionaryDataBase)((Object)dictionaryData)).setFullName(((DictionaryDataBase)((Object)parent)).getFullName() + "$$" + ((DictionaryDataBase)((Object)dictionaryData)).getName());
                ((DictionaryDataBase)((Object)dictionaryData)).setFullId(((DictionaryDataBase)((Object)parent)).getFullId() + "$$" + ((DictionaryDataBase)((Object)dictionaryData)).getId());
            } else {
                ((DictionaryDataBase)((Object)dictionaryData)).setFullCode(((DictionaryDataBase)((Object)dictionaryData)).getCode());
                ((DictionaryDataBase)((Object)dictionaryData)).setFullName(((DictionaryDataBase)((Object)dictionaryData)).getName());
                ((DictionaryDataBase)((Object)dictionaryData)).setFullId(((DictionaryDataBase)((Object)dictionaryData)).getId());
            }
            try {
                AbstractDictionaryDataManager.this.cache().addAndRefresh(AbstractDictionaryDataManager.this.dataSource(), (DictionaryDataBase)((Object)dictionaryData));
            }
            catch (NotFoundCacheException e) {
                e.printStackTrace();
            }
        }

        public void delete(String fullCode) {
            DictionaryDataBase dictionaryData = DictionaryUtil.coverDicBean(AbstractDictionaryDataManager.this.dataSource(), fullCode, "$$");
            if (dictionaryData == null) {
                throw new NoSuchElementException(String.format("Did not find dictionary [%s]", fullCode));
            }
            this.delete((Object)((Object)dictionaryData));
        }

        public void deleteById(String id) {
            Object dic = DictionaryUtil.findById(AbstractDictionaryDataManager.this.dataSource(), id);
            this.delete(dic);
        }

        public void delete(String fullCode, String split) {
            this.delete(fullCode.replace(split, "$$"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete(D dictionaryData) {
            SyncProxy syncProxy = this;
            synchronized (syncProxy) {
                this.deleteData(dictionaryData);
                AbstractDictionaryDataManager.this.cache().refresh(AbstractDictionaryDataManager.this.dataSource());
            }
        }

        private void deleteData(D dictionaryData) {
            if (dictionaryData == null) {
                return;
            }
            Optional.ofNullable(dictionaryData.getChildren()).ifPresent(children -> children.stream().map(a -> a).forEach(this::deleteData));
            AbstractDictionaryDataManager.this.delete(dictionaryData);
            this.deleteCache(dictionaryData);
        }

        private void deleteCache(D dictionaryData) {
            Object oldData = AbstractDictionaryDataManager.this.findOne(((DictionaryDataBase)((Object)dictionaryData)).getId());
            if (oldData == null) {
                return;
            }
            try {
                AbstractDictionaryDataManager.this.cache().deleteAndRefresh(AbstractDictionaryDataManager.this.dataSource(), (DictionaryDataBase)((Object)oldData));
            }
            catch (NotFoundCacheException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(D dictionaryData) {
            SyncProxy syncProxy = this;
            synchronized (syncProxy) {
                if (Objects.equals(((DictionaryDataBase)((Object)dictionaryData)).getId(), ((DictionaryDataBase)((Object)dictionaryData)).getParentId())) {
                    throw new IllegalArgumentException("\u7236\u4e3b\u952e\u4e0e\u4e3b\u952e\u4e0d\u80fd\u76f8\u540c");
                }
                this.updateData(dictionaryData, AbstractDictionaryDataManager.this::update, true, false);
                AbstractDictionaryDataManager.this.cache().refresh(AbstractDictionaryDataManager.this.dataSource());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateOfNotNull(D dictionaryData) {
            SyncProxy syncProxy = this;
            synchronized (syncProxy) {
                this.updateData(dictionaryData, AbstractDictionaryDataManager.this::updateOfNotNull, true, true);
                AbstractDictionaryDataManager.this.cache().refresh(AbstractDictionaryDataManager.this.dataSource());
            }
        }

        private void updateData(D newData, Function<D, D> function, boolean ignoreChildren, boolean ignoreNullField) {
            Object oldData = AbstractDictionaryDataManager.this.findOne(((DictionaryDataBase)((Object)newData)).getId());
            if (oldData == null) {
                this.addData(newData);
                return;
            }
            if ((newData = (DictionaryDataBase)((Object)function.apply(newData))) == null) {
                throw new RuntimeException("sorry!you must return an object");
            }
            this.updateCache(newData, ignoreNullField);
        }

        private void replaceProperties(D newData, DictionaryDataBase oldData, boolean ignoreNullField) {
            String[] requireField = new String[]{"code", "name", "sort", "parentId", "fullCode", "fullName", "fullId"};
            ObjectUtil.copyProperties(newData, (Object)((Object)oldData), (String)"", (String)"", (String[])requireField, (ObjectUtil.ContainOrExclude)ObjectUtil.ContainOrExclude.INCLUDE, (ObjectUtil.Compare)ObjectUtil.Compare.DIFF_SOURCE_NOT_NULL, (boolean)false);
            String parentId = ((DictionaryDataBase)((Object)newData)).getParentId();
            if (parentId == null && !ignoreNullField) {
                oldData.setParentId(null);
            }
            ObjectUtil.Compare compare = ignoreNullField ? ObjectUtil.Compare.DIFF_SOURCE_NOT_NULL : ObjectUtil.Compare.DIFF;
            String[] exclude = new String[]{"code", "name", "sort", "parentId", "fullCode", "fullName", "fullId", "children"};
            ObjectUtil.copyProperties(newData, (Object)((Object)oldData), (String)"", (String)"", (String[])exclude, (ObjectUtil.ContainOrExclude)ObjectUtil.ContainOrExclude.EXCLUDE, (ObjectUtil.Compare)compare, (boolean)false);
        }

        private void updateCache(D newData, boolean ignoreNullField) {
            Object oldData = AbstractDictionaryDataManager.this.findOne(((DictionaryDataBase)((Object)newData)).getId());
            this.deleteMemory(oldData);
            this.replaceProperties(newData, (DictionaryDataBase)((Object)oldData), ignoreNullField);
            Object parent = AbstractDictionaryDataManager.this.findOne(((DictionaryDataBase)((Object)oldData)).getParentId());
            try {
                AbstractDictionaryDataManager.this.cache().refreshLeaf(AbstractDictionaryDataManager.this.dataSource(), oldData, parent);
                AbstractDictionaryDataManager.this.cache().refreshToRoot(AbstractDictionaryDataManager.this.dataSource(), parent);
            }
            catch (NotFoundCacheException e) {
                e.printStackTrace();
            }
        }

        void deleteMemory(D oldData) {
            oldData.getChildren().forEach(a -> this.deleteMemory((Object)a));
            try {
                AbstractDictionaryDataManager.this.cache().deleteAndRefresh(AbstractDictionaryDataManager.this.dataSource(), (DictionaryDataBase)((Object)oldData));
            }
            catch (NotFoundCacheException e) {
                e.printStackTrace();
            }
        }
    }
}

