/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.dictionary;

import cloud.agileframework.common.util.collection.TreeBase;
import java.io.Serializable;
import java.util.Objects;

public class DictionaryDataBase
extends TreeBase<String, DictionaryDataBase> {
    private String code;
    private String name;
    private String fullName;
    private String fullCode;
    private String fullId;

    public DictionaryDataBase() {
    }

    public DictionaryDataBase(String id, String parentId, String name, String code) {
        this.setId((Serializable)((Object)id));
        this.setParentId((Serializable)((Object)parentId));
        this.name = name;
        this.code = code;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getFullCode() {
        return this.fullCode;
    }

    public String getFullId() {
        return this.fullId;
    }

    public String getFullName(String splitChar) {
        return this.fullName.replace("$$", splitChar);
    }

    public String getFullCode(String splitChar) {
        return this.fullCode.replace("$$", splitChar);
    }

    public String getFullId(String splitChar) {
        return this.fullId.replace("$$", splitChar);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DictionaryDataBase)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DictionaryDataBase that = (DictionaryDataBase)((Object)o);
        return Objects.equals(this.getCode(), that.getCode()) && Objects.equals(this.getName(), that.getName());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getCode(), this.getName());
    }

    public String getId() {
        return (String)((Object)super.getId());
    }

    public String getParentId() {
        return (String)((Object)super.getParentId());
    }

    protected DictionaryDataBase(DictionaryDataBaseBuilder<?, ?> b) {
        super(b);
        this.code = ((DictionaryDataBaseBuilder)b).code;
        this.name = ((DictionaryDataBaseBuilder)b).name;
        this.fullName = ((DictionaryDataBaseBuilder)b).fullName;
        this.fullCode = ((DictionaryDataBaseBuilder)b).fullCode;
        this.fullId = ((DictionaryDataBaseBuilder)b).fullId;
    }

    public static DictionaryDataBaseBuilder<?, ?> builder() {
        return new DictionaryDataBaseBuilderImpl();
    }

    public DictionaryDataBaseBuilder<?, ?> toBuilder() {
        return new DictionaryDataBaseBuilderImpl().$fillValuesFrom(this);
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public void setFullCode(String fullCode) {
        this.fullCode = fullCode;
    }

    public void setFullId(String fullId) {
        this.fullId = fullId;
    }

    public String toString() {
        return "DictionaryDataBase(super=" + super.toString() + ", code=" + this.getCode() + ", name=" + this.getName() + ", fullName=" + this.getFullName() + ", fullCode=" + this.getFullCode() + ", fullId=" + this.getFullId() + ")";
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    private static final class DictionaryDataBaseBuilderImpl
    extends DictionaryDataBaseBuilder<DictionaryDataBase, DictionaryDataBaseBuilderImpl> {
        private DictionaryDataBaseBuilderImpl() {
        }

        @Override
        protected DictionaryDataBaseBuilderImpl self() {
            return this;
        }

        @Override
        public DictionaryDataBase build() {
            return new DictionaryDataBase(this);
        }
    }

    public static abstract class DictionaryDataBaseBuilder<C extends DictionaryDataBase, B extends DictionaryDataBaseBuilder<C, B>>
    extends TreeBase.TreeBaseBuilder<String, DictionaryDataBase, C, B> {
        private String code;
        private String name;
        private String fullName;
        private String fullCode;
        private String fullId;

        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DictionaryDataBaseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(DictionaryDataBase instance, DictionaryDataBaseBuilder<?, ?> b) {
            b.code(instance.code);
            b.name(instance.name);
            b.fullName(instance.fullName);
            b.fullCode(instance.fullCode);
            b.fullId(instance.fullId);
        }

        protected abstract B self();

        public abstract C build();

        public B code(String code) {
            this.code = code;
            return (B)this.self();
        }

        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        public B fullName(String fullName) {
            this.fullName = fullName;
            return (B)this.self();
        }

        public B fullCode(String fullCode) {
            this.fullCode = fullCode;
            return (B)this.self();
        }

        public B fullId(String fullId) {
            this.fullId = fullId;
            return (B)this.self();
        }

        public String toString() {
            return "DictionaryDataBase.DictionaryDataBaseBuilder(super=" + super.toString() + ", code=" + this.code + ", name=" + this.name + ", fullName=" + this.fullName + ", fullCode=" + this.fullCode + ", fullId=" + this.fullId + ")";
        }
    }
}

