/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.dictionary;

import cloud.agileframework.common.util.collection.TreeUtil;
import cloud.agileframework.dictionary.DictionaryDataBase;
import cloud.agileframework.dictionary.DictionaryDataManager;
import cloud.agileframework.dictionary.cache.DictionaryCacheUtil;
import cloud.agileframework.dictionary.cache.NotFoundCacheException;
import cloud.agileframework.dictionary.util.DictionaryUtil;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.Order;

@Order(value=-2147483648)
public class DictionaryEngine
implements ApplicationRunner,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private static Map<String, DictionaryDataManager<? extends DictionaryDataBase>> dictionaryDataManagerMap = Maps.newConcurrentMap();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void run(ApplicationArguments args) {
        this.applicationContext.getBeanProvider(DictionaryDataManager.class).orderedStream().forEach(cm -> {
            try {
                this.parseDataSource((DictionaryDataManager<?>)cm);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void parseDataSource(DictionaryDataManager<?> dictionaryDataManager) throws NotFoundCacheException {
        DictionaryCacheUtil.setDictionaryCache(dictionaryDataManager.dataSource(), dictionaryDataManager.cache());
        dictionaryDataManagerMap.put(dictionaryDataManager.dataSource(), dictionaryDataManager);
        ConcurrentSkipListSet<DictionaryDataBase> treeSet = new ConcurrentSkipListSet<DictionaryDataBase>(dictionaryDataManager.all());
        if (this.isFinish(dictionaryDataManager.dataSource(), treeSet)) {
            return;
        }
        treeSet.forEach(dic -> {
            dic.setFullCode(dic.getCode());
            dic.setFullName(dic.getName());
            dic.setFullId(dic.getId());
        });
        TreeUtil.createTree(treeSet, (Serializable)((Object)dictionaryDataManager.rootParentId()), (String)"$$", (String[])new String[]{"fullName", "fullCode", "fullId"});
        dictionaryDataManager.cache().initData(dictionaryDataManager.dataSource(), treeSet);
    }

    private boolean isFinish(String dataSource, SortedSet<DictionaryDataBase> newData) {
        SortedSet<DictionaryDataBase> old = DictionaryUtil.findAll(dataSource);
        return CollectionUtils.isEqualCollection(newData, old);
    }

    public static DictionaryDataManager<? extends DictionaryDataBase> getDictionaryDataManagerMap(String datasource) {
        return dictionaryDataManagerMap.get(datasource);
    }

    public static enum CacheType {
        CODE_CACHE,
        NAME_CACHE;

    }
}

