/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.dictionary;

import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.dictionary.AbstractDictionaryDataManager;
import cloud.agileframework.dictionary.DictionaryDataBase;
import cloud.agileframework.dictionary.cache.DictionaryCache;
import cloud.agileframework.dictionary.cache.MemoryCacheImpl;
import cloud.agileframework.dictionary.util.DictionaryUtil;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class MemoryDictionaryManager
extends AbstractDictionaryDataManager<DictionaryDataBase> {
    private static final Set<DictionaryDataBase> CACHE = Sets.newHashSet();

    public static Set<DictionaryDataBase> store() {
        return CACHE;
    }

    @Override
    public List<DictionaryDataBase> all() {
        return new ArrayList<DictionaryDataBase>(CACHE);
    }

    @Override
    public String dataSource() {
        return "DICTIONARY_DATA_CACHE";
    }

    @Override
    public void add(DictionaryDataBase dictionaryDataBase) {
        CACHE.add(dictionaryDataBase);
    }

    @Override
    public void delete(DictionaryDataBase dictionaryDataBase) {
        CACHE.removeIf(n -> dictionaryDataBase.getId().equals(n.getId()));
    }

    @Override
    public DictionaryDataBase update(DictionaryDataBase dictionaryDataBase) {
        this.delete(dictionaryDataBase);
        this.add(dictionaryDataBase);
        return dictionaryDataBase;
    }

    @Override
    public DictionaryDataBase updateOfNotNull(DictionaryDataBase dictionaryDataBase) {
        Object dic = DictionaryUtil.findById(this.dataSource(), dictionaryDataBase.getId());
        ObjectUtil.copyProperties((Object)((Object)dictionaryDataBase), dic, (ObjectUtil.Compare)ObjectUtil.Compare.DIFF_SOURCE_NOT_NULL);
        this.update((DictionaryDataBase)((Object)dic));
        return dic;
    }

    @Override
    public DictionaryCache cache() {
        return MemoryCacheImpl.INSTANT;
    }
}

