/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.dictionary.cache;

import cloud.agileframework.cache.support.AgileCache;
import cloud.agileframework.cache.util.CacheUtil;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.dictionary.DictionaryDataBase;
import cloud.agileframework.dictionary.cache.DictionaryCache;
import cloud.agileframework.dictionary.cache.NotFoundCacheException;
import cloud.agileframework.dictionary.cache.RegionEnum;
import com.google.common.collect.Maps;
import java.util.Map;
import org.springframework.cache.Cache;

public class AgileCacheImpl
implements DictionaryCache {
    public static final AgileCacheImpl INSTANT = new AgileCacheImpl();

    private AgileCache getAgileCache(String datasource) {
        return CacheUtil.getCache((String)datasource);
    }

    @Override
    public void initData(String datasource, RegionEnum regionEnum, Map<String, DictionaryDataBase> cacheData) {
        this.getAgileCache(datasource).put((Object)regionEnum, cacheData);
    }

    @Override
    public Map<String, DictionaryDataBase> getDataByRegion(String datasource, RegionEnum regionEnum) throws NotFoundCacheException {
        AgileCache cache = this.getAgileCache(datasource);
        if (cache == null) {
            throw new NotFoundCacheException("Unable to get dictionary's cache");
        }
        Cache.ValueWrapper result = cache.get((Object)regionEnum.name());
        if (result == null) {
            return Maps.newHashMap();
        }
        Map data = (Map)cache.get((Object)regionEnum.name(), (TypeReference)new TypeReference<Map<String, DictionaryDataBase>>(){});
        if (data == null) {
            return Maps.newHashMap();
        }
        return data;
    }

    @Override
    public DictionaryDataBase getByFullIndex(String datasource, RegionEnum regionEnum, String fullIndex) throws NotFoundCacheException {
        AgileCache cache = this.getAgileCache(datasource);
        if (cache == null) {
            throw new NotFoundCacheException("Unable to get dictionary's cache");
        }
        return (DictionaryDataBase)((Object)cache.getFromMap((Object)regionEnum.name(), (Object)fullIndex, DictionaryDataBase.class));
    }

    @Override
    public synchronized void add(String datasource, DictionaryDataBase dictionaryData) throws NotFoundCacheException {
        AgileCache cache = this.getAgileCache(datasource);
        if (cache == null) {
            throw new NotFoundCacheException("Unable to get dictionary's cache");
        }
        cache.addToMap((Object)RegionEnum.CODE_MEMORY.name(), (Object)dictionaryData.getFullCode(), (Object)dictionaryData);
        cache.addToMap((Object)RegionEnum.NAME_MEMORY.name(), (Object)dictionaryData.getFullName(), (Object)dictionaryData);
        cache.addToMap((Object)RegionEnum.FULL_ID_MEMORY.name(), (Object)dictionaryData.getFullId(), (Object)dictionaryData);
        cache.addToMap((Object)RegionEnum.ID_MEMORY.name(), (Object)dictionaryData.getId(), (Object)dictionaryData);
    }

    @Override
    public synchronized void delete(String datasource, DictionaryDataBase dictionaryData) throws NotFoundCacheException {
        AgileCache cache = this.getAgileCache(datasource);
        if (cache == null) {
            throw new NotFoundCacheException("Unable to get dictionary's cache");
        }
        cache.removeFromMap((Object)RegionEnum.NAME_MEMORY.name(), (Object)dictionaryData.getFullName());
        cache.removeFromMap((Object)RegionEnum.CODE_MEMORY.name(), (Object)dictionaryData.getFullCode());
        cache.removeFromMap((Object)RegionEnum.FULL_ID_MEMORY.name(), (Object)dictionaryData.getFullId());
        cache.removeFromMap((Object)RegionEnum.ID_MEMORY.name(), (Object)dictionaryData.getId());
    }
}

