/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.dictionary.cache;

import cloud.agileframework.common.util.collection.TreeUtil;
import cloud.agileframework.dictionary.DictionaryDataBase;
import cloud.agileframework.dictionary.cache.NotFoundCacheException;
import cloud.agileframework.dictionary.cache.RegionEnum;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;

public interface DictionaryCache {
    default public void initData(String datasource, SortedSet<DictionaryDataBase> treeSet) throws NotFoundCacheException {
        HashMap codeMap = Maps.newHashMap();
        HashMap nameMap = Maps.newHashMap();
        HashMap idMap = Maps.newHashMap();
        HashMap fullIdMap = Maps.newHashMap();
        treeSet.forEach(dic -> {
            codeMap.put(dic.getFullCode(), dic);
            nameMap.put(dic.getFullName(), dic);
            idMap.put(dic.getId(), dic);
            fullIdMap.put(dic.getFullId(), dic);
        });
        this.initData(datasource, RegionEnum.CODE_MEMORY, codeMap);
        this.initData(datasource, RegionEnum.NAME_MEMORY, nameMap);
        this.initData(datasource, RegionEnum.ID_MEMORY, idMap);
        this.initData(datasource, RegionEnum.FULL_ID_MEMORY, fullIdMap);
    }

    public void initData(String var1, RegionEnum var2, Map<String, DictionaryDataBase> var3) throws NotFoundCacheException;

    public Map<String, DictionaryDataBase> getDataByRegion(String var1, RegionEnum var2) throws NotFoundCacheException;

    default public SortedSet<DictionaryDataBase> getDataByDatasource(String datasource) throws NotFoundCacheException {
        return new ConcurrentSkipListSet<DictionaryDataBase>(this.getDataByRegion(datasource, RegionEnum.ID_MEMORY).values());
    }

    default public DictionaryDataBase getByFullIndex(String datasource, RegionEnum regionEnum, String fullIndex) throws NotFoundCacheException {
        Map<String, DictionaryDataBase> data = this.getDataByRegion(datasource, regionEnum);
        if (data == null) {
            return null;
        }
        return data.get(fullIndex);
    }

    default public ConcurrentSkipListSet<DictionaryDataBase> likeByFullIndex(String datasource, RegionEnum regionEnum, String fullIndex) {
        Map<String, DictionaryDataBase> data = null;
        try {
            data = this.getDataByRegion(datasource, regionEnum);
        }
        catch (NotFoundCacheException e) {
            e.printStackTrace();
        }
        if (data == null) {
            return new ConcurrentSkipListSet<DictionaryDataBase>();
        }
        return data.entrySet().stream().filter(node -> ((String)node.getKey()).startsWith(fullIndex + "$$")).map(Map.Entry::getValue).collect(Collectors.toCollection(ConcurrentSkipListSet::new));
    }

    public void add(String var1, DictionaryDataBase var2) throws NotFoundCacheException;

    public void delete(String var1, DictionaryDataBase var2) throws NotFoundCacheException;

    default public void addAndRefresh(String datasource, DictionaryDataBase dictionaryData) throws NotFoundCacheException {
        this.add(datasource, dictionaryData);
        String parentId = dictionaryData.getParentId();
        if (parentId != null) {
            Object parent = this.findById(datasource, parentId);
            this.refreshToRoot(datasource, (DictionaryDataBase)((Object)parent));
        }
    }

    default public void deleteAndRefresh(String datasource, DictionaryDataBase dictionaryData) throws NotFoundCacheException {
        this.delete(datasource, dictionaryData);
        String parentId = dictionaryData.getParentId();
        if (parentId != null) {
            Object parent = this.findById(datasource, parentId);
            this.refreshToRoot(datasource, (DictionaryDataBase)((Object)parent));
        }
    }

    default public <A extends DictionaryDataBase> void refreshLeaf(String datasource, A entity, A parent) throws NotFoundCacheException {
        String newFullId;
        String newFullName;
        String newFullCode;
        if (entity == null) {
            return;
        }
        if (parent != null) {
            newFullCode = parent.getFullCode() + "$$" + entity.getCode();
            newFullName = parent.getFullName() + "$$" + entity.getName();
            newFullId = parent.getFullId() + "$$" + entity.getId();
        } else {
            newFullCode = entity.getCode();
            newFullName = entity.getName();
            newFullId = entity.getId();
        }
        entity.setFullCode(newFullCode);
        entity.setFullName(newFullName);
        entity.setFullId(newFullId);
        this.add(datasource, entity);
        for (DictionaryDataBase child : entity.getChildren()) {
            this.refreshLeaf(datasource, child, entity);
        }
    }

    default public <A extends DictionaryDataBase> void refreshToRoot(String datasource, A entity) throws NotFoundCacheException {
        if (entity == null) {
            return;
        }
        String fullIndex = entity.getFullId();
        ConcurrentSkipListSet<DictionaryDataBase> children = this.likeByFullIndex(datasource, RegionEnum.FULL_ID_MEMORY, fullIndex);
        children.forEach(dic -> {
            dic.setFullCode(dic.getCode());
            dic.setFullName(dic.getName());
            dic.setFullId(dic.getId());
        });
        children.add(entity);
        TreeUtil.createTree(children, (Serializable)((Object)entity.getParentId()), (String)"$$", (String[])new String[]{"fullName", "fullCode", "fullId"});
        String id = entity.getId();
        entity.setChildren(children.stream().filter(n -> id.equals(n.getParentId())).collect(Collectors.toCollection(ConcurrentSkipListSet::new)));
        this.add(datasource, entity);
        String parentId = entity.getParentId();
        if (parentId != null) {
            Object parent = this.findById(datasource, parentId);
            this.refreshToRoot(datasource, (A)((Object)parent));
        }
    }

    default public <D extends DictionaryDataBase> D findById(String datasource, String id) throws NotFoundCacheException {
        return (D)((Object)this.getDataByRegion(datasource, RegionEnum.ID_MEMORY).get(id));
    }

    default public void refresh(String datasource) {
    }
}

