/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.dictionary.cache;

import cloud.agileframework.dictionary.cache.DictionaryCache;
import cloud.agileframework.dictionary.cache.NotFoundCacheException;
import com.google.common.collect.Maps;
import java.util.Map;

public class DictionaryCacheUtil {
    private static final Map<String, DictionaryCache> map = Maps.newConcurrentMap();

    public static void setDictionaryCache(String datasource, DictionaryCache dictionaryCache) {
        if (map.get(datasource) != null) {
            throw new IllegalArgumentException(datasource + "\u7f13\u5b58\u8bbe\u7f6e\u91cd\u590d");
        }
        map.put(datasource, dictionaryCache);
    }

    public static DictionaryCache getDictionaryCache(String datasource) throws NotFoundCacheException {
        DictionaryCache cache = map.get(datasource);
        if (cache == null) {
            throw new NotFoundCacheException(datasource + "\u7f13\u5b58\u4e0d\u5b58\u5728");
        }
        return cache;
    }
}

