/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.dictionary.cache;

import cloud.agileframework.dictionary.DictionaryDataBase;
import cloud.agileframework.dictionary.cache.DictionaryCache;
import cloud.agileframework.dictionary.cache.NotFoundCacheException;
import cloud.agileframework.dictionary.cache.RegionEnum;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;

public class MemoryCacheImpl
implements DictionaryCache {
    public static final MemoryCacheImpl INSTANT = new MemoryCacheImpl();
    private static final Map<String, Map<RegionEnum, Map<String, DictionaryDataBase>>> REGION_DATA = Maps.newConcurrentMap();

    @Override
    public void initData(String datasource, RegionEnum regionEnum, Map<String, DictionaryDataBase> cacheData) {
        HashMap data = REGION_DATA.get(datasource);
        if (data == null) {
            data = Maps.newHashMap();
        }
        data.put(regionEnum, cacheData);
        REGION_DATA.put(datasource, data);
    }

    @Override
    public Map<String, DictionaryDataBase> getDataByRegion(String datasource, RegionEnum regionEnum) {
        Map<RegionEnum, Map<String, DictionaryDataBase>> data = REGION_DATA.get(datasource);
        if (data == null) {
            return Maps.newHashMap();
        }
        Map<String, DictionaryDataBase> result = data.get((Object)regionEnum);
        if (result == null) {
            return Maps.newHashMap();
        }
        return result;
    }

    @Override
    public synchronized void add(String datasource, DictionaryDataBase dictionaryData) throws NotFoundCacheException {
        Map<RegionEnum, Map<String, DictionaryDataBase>> regionData = REGION_DATA.get(datasource);
        if (regionData == null) {
            ConcurrentSkipListSet<DictionaryDataBase> sortedSet = new ConcurrentSkipListSet<DictionaryDataBase>();
            sortedSet.add(dictionaryData);
            this.initData(datasource, sortedSet);
            return;
        }
        Map codeData = regionData.computeIfAbsent(RegionEnum.CODE_MEMORY, k -> Maps.newHashMap());
        codeData.put(dictionaryData.getFullCode(), dictionaryData);
        Map nameData = regionData.computeIfAbsent(RegionEnum.NAME_MEMORY, k -> Maps.newHashMap());
        nameData.put(dictionaryData.getFullName(), dictionaryData);
        Map fullIdData = regionData.computeIfAbsent(RegionEnum.FULL_ID_MEMORY, k -> Maps.newHashMap());
        fullIdData.put(dictionaryData.getFullId(), dictionaryData);
        Map idData = regionData.computeIfAbsent(RegionEnum.ID_MEMORY, k -> Maps.newHashMap());
        idData.put(dictionaryData.getId(), dictionaryData);
    }

    @Override
    public synchronized void delete(String datasource, DictionaryDataBase dictionaryData) throws NotFoundCacheException {
        Map<RegionEnum, Map<String, DictionaryDataBase>> regionData = REGION_DATA.get(datasource);
        if (regionData == null) {
            return;
        }
        regionData.computeIfPresent(RegionEnum.CODE_MEMORY, (regionEnum, stringDictionaryDataBaseMap) -> {
            stringDictionaryDataBaseMap.remove(dictionaryData.getFullCode());
            return stringDictionaryDataBaseMap;
        });
        regionData.computeIfPresent(RegionEnum.NAME_MEMORY, (regionEnum, stringDictionaryDataBaseMap) -> {
            stringDictionaryDataBaseMap.remove(dictionaryData.getFullName());
            return stringDictionaryDataBaseMap;
        });
        regionData.computeIfPresent(RegionEnum.FULL_ID_MEMORY, (regionEnum, stringDictionaryDataBaseMap) -> {
            stringDictionaryDataBaseMap.remove(dictionaryData.getFullId());
            return stringDictionaryDataBaseMap;
        });
        regionData.computeIfPresent(RegionEnum.ID_MEMORY, (regionEnum, stringDictionaryDataBaseMap) -> {
            stringDictionaryDataBaseMap.remove(dictionaryData.getId());
            return stringDictionaryDataBaseMap;
        });
    }
}

