/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.dictionary.cache;

import cloud.agileframework.cache.util.BeanUtil;
import cloud.agileframework.dictionary.DictionaryDataBase;
import cloud.agileframework.dictionary.cache.DictionaryCache;
import cloud.agileframework.dictionary.cache.NotFoundCacheException;
import cloud.agileframework.dictionary.cache.RegionEnum;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class SpringCacheImpl
implements DictionaryCache {
    public static final SpringCacheImpl INSTANT = new SpringCacheImpl((CacheManager)BeanUtil.getApplicationContext().getBean(CacheManager.class));
    private final CacheManager cacheManager;

    public SpringCacheImpl(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public void initData(String datasource, RegionEnum regionEnum, Map<String, DictionaryDataBase> cacheData) throws NotFoundCacheException {
        Cache regionCache = this.getCache(datasource);
        regionCache.put((Object)regionEnum.name(), cacheData);
    }

    private Cache getCache(String datasource) throws NotFoundCacheException {
        Cache regionCache = this.cacheManager.getCache(datasource);
        if (regionCache == null) {
            throw new NotFoundCacheException("Unable to get Dictionary's cache object");
        }
        return regionCache;
    }

    @Override
    public Map<String, DictionaryDataBase> getDataByRegion(String datasource, RegionEnum regionEnum) throws NotFoundCacheException {
        Cache regionCache = this.getCache(datasource);
        Cache.ValueWrapper result = regionCache.get((Object)regionEnum.name());
        if (result == null) {
            return Maps.newHashMap();
        }
        return (Map)result.get();
    }

    @Override
    public void add(String datasource, DictionaryDataBase dictionaryData) throws NotFoundCacheException {
        HashMap codeData = this.getDataByRegion(datasource, RegionEnum.CODE_MEMORY);
        if (codeData == null) {
            codeData = Maps.newHashMap();
        }
        codeData.put(dictionaryData.getFullCode(), dictionaryData);
        this.initData(datasource, RegionEnum.CODE_MEMORY, codeData);
        HashMap nameData = this.getDataByRegion(datasource, RegionEnum.NAME_MEMORY);
        if (nameData == null) {
            nameData = Maps.newHashMap();
        }
        nameData.put(dictionaryData.getFullName(), dictionaryData);
        this.initData(datasource, RegionEnum.NAME_MEMORY, nameData);
        HashMap fullIdData = this.getDataByRegion(datasource, RegionEnum.FULL_ID_MEMORY);
        if (fullIdData == null) {
            fullIdData = Maps.newHashMap();
        }
        fullIdData.put(dictionaryData.getFullId(), dictionaryData);
        this.initData(datasource, RegionEnum.FULL_ID_MEMORY, fullIdData);
        HashMap idData = this.getDataByRegion(datasource, RegionEnum.ID_MEMORY);
        if (idData == null) {
            idData = Maps.newHashMap();
        }
        idData.put(dictionaryData.getId(), dictionaryData);
        this.initData(datasource, RegionEnum.ID_MEMORY, idData);
    }

    @Override
    public void delete(String datasource, DictionaryDataBase dictionaryData) throws NotFoundCacheException {
        Map<String, DictionaryDataBase> codeMap = this.getDataByRegion(datasource, RegionEnum.CODE_MEMORY);
        codeMap.remove(dictionaryData.getFullCode());
        this.initData(datasource, RegionEnum.CODE_MEMORY, codeMap);
        Map<String, DictionaryDataBase> nameMap = this.getDataByRegion(datasource, RegionEnum.NAME_MEMORY);
        nameMap.remove(dictionaryData.getFullName());
        this.initData(datasource, RegionEnum.NAME_MEMORY, nameMap);
        Map<String, DictionaryDataBase> fullIdMap = this.getDataByRegion(datasource, RegionEnum.FULL_ID_MEMORY);
        fullIdMap.remove(dictionaryData.getFullId());
        this.initData(datasource, RegionEnum.FULL_ID_MEMORY, fullIdMap);
        Map<String, DictionaryDataBase> idMap = this.getDataByRegion(datasource, RegionEnum.ID_MEMORY);
        idMap.remove(dictionaryData.getId());
        this.initData(datasource, RegionEnum.ID_MEMORY, idMap);
    }
}

