/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.dictionary.config;

import cloud.agileframework.dictionary.DictionaryDataManager;
import cloud.agileframework.dictionary.DictionaryEngine;
import cloud.agileframework.dictionary.DictionaryProperties;
import cloud.agileframework.dictionary.MemoryDictionaryManager;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(name={"cloud.agileframework.jpa.config.DaoAutoConfiguration.class"})
@ConditionalOnProperty(name={"enable"}, prefix="agile.dictionary", matchIfMissing=true)
@EnableConfigurationProperties(value={DictionaryProperties.class})
@AutoConfigureAfter(name={"cloud.agileframework.cache.config.EhCacheAutoConfiguration.class"})
public class DictionaryAutoConfiguration {
    @Bean
    DictionaryEngine dictionaryEngine() {
        return new DictionaryEngine();
    }

    @Bean
    @ConditionalOnMissingBean(value={DictionaryDataManager.class})
    MemoryDictionaryManager dictionaryManager() {
        return new MemoryDictionaryManager();
    }
}

