/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.dictionary.util;

import cloud.agileframework.dictionary.DictionaryDataBase;
import cloud.agileframework.dictionary.DictionaryEngine;
import cloud.agileframework.dictionary.cache.DictionaryCacheUtil;
import cloud.agileframework.dictionary.cache.RegionEnum;
import cloud.agileframework.dictionary.util.DictionaryUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConvertBase {
    static final Logger LOGGER = LoggerFactory.getLogger(DictionaryUtil.class);

    ConvertBase() {
    }

    static DictionaryDataBase getDictionary(String fullIndex, DictionaryEngine.CacheType cacheType, String errorMessage, String splitChar) {
        return ConvertBase.getDictionary("DICTIONARY_DATA_CACHE", fullIndex, cacheType, errorMessage, splitChar);
    }

    static DictionaryDataBase getDictionary(String datasource, String fullIndex, DictionaryEngine.CacheType cacheType, String errorMessage, String splitChar) {
        if (StringUtils.isEmpty((CharSequence)fullIndex)) {
            return null;
        }
        fullIndex = fullIndex.replace(splitChar, "$$");
        DictionaryDataBase entity = null;
        try {
            entity = DictionaryEngine.CacheType.CODE_CACHE == cacheType ? DictionaryCacheUtil.getDictionaryCache(datasource).getByFullIndex(datasource, RegionEnum.CODE_MEMORY, fullIndex) : (DictionaryEngine.CacheType.NAME_CACHE == cacheType ? DictionaryCacheUtil.getDictionaryCache(datasource).getByFullIndex(datasource, RegionEnum.NAME_MEMORY, fullIndex) : DictionaryCacheUtil.getDictionaryCache(datasource).getByFullIndex(datasource, RegionEnum.ID_MEMORY, fullIndex));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (entity == null) {
            LOGGER.error(errorMessage, (Object)fullIndex);
            return null;
        }
        return entity;
    }
}

