/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.dictionary.util;

import cloud.agileframework.common.util.clazz.ClassUtil;
import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.common.util.string.StringUtil;
import cloud.agileframework.dictionary.DictionaryDataBase;
import cloud.agileframework.dictionary.annotation.Dictionary;
import cloud.agileframework.dictionary.annotation.DictionaryField;
import cloud.agileframework.dictionary.util.ConvertDicMap;
import cloud.agileframework.dictionary.util.DictionaryUtil;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ObjectUtils;

public class ConvertDicAnnotation
extends ConvertDicMap {
    private static Map<String, String> dicCoverCache;

    public static <T> void cover(T o) {
        if (ObjectUtils.isEmpty(o)) {
            return;
        }
        if (Collection.class.isAssignableFrom(o.getClass())) {
            ConvertDicAnnotation.cover((Collection)o);
        }
        Set targets = ClassUtil.getAllEntityAnnotation(o.getClass(), Dictionary.class);
        targets.forEach(target -> {
            Field field;
            Dictionary dictionary = (Dictionary)target.getAnnotation();
            Member member = target.getMember();
            if (member instanceof Method) {
                String fieldName = StringUtil.toLowerName((String)member.getName().substring(3));
                field = ClassUtil.getField(o.getClass(), (String)fieldName);
                if (ObjectUtils.isEmpty((Object)field)) {
                    return;
                }
            } else if (member instanceof Field) {
                field = (Field)member;
            } else {
                return;
            }
            ConvertDicAnnotation.parseNodeField(dictionary, field, o);
        });
        Set dictionaryTargets = ClassUtil.getAllEntityAnnotation(o.getClass(), DictionaryField.class);
        dictionaryTargets.forEach(dictionaryTarget -> {
            String fieldName;
            Member member = dictionaryTarget.getMember();
            if (member instanceof Method) {
                fieldName = StringUtil.toLowerName((String)member.getName().substring(3));
            } else if (member instanceof Field) {
                fieldName = member.getName();
            } else {
                return;
            }
            Object value = ObjectUtil.getFieldValue((Object)o, (String)fieldName);
            ConvertDicAnnotation.cover(value);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void cover(Collection<T> collection) {
        Collection<T> c;
        if (ObjectUtils.isEmpty(collection)) {
            return;
        }
        if (dicCoverCache == null) {
            dicCoverCache = Maps.newConcurrentMap();
        }
        Collection<T> collection2 = c = Collections.synchronizedCollection(collection);
        synchronized (collection2) {
            collection.parallelStream().forEach(ConvertDicAnnotation::cover);
        }
        dicCoverCache.clear();
    }

    private static <T> void parseNodeField(Dictionary dictionary, Field field, T node) {
        Object value;
        DictionaryDataBase parent;
        String[] fieldNames = dictionary.fieldName();
        if (fieldNames.length == 0) {
            return;
        }
        String currentFieldName = fieldNames.length > 1 ? fieldNames[fieldNames.length - 1] : fieldNames[0];
        Object fieldValue = ObjectUtil.getFieldValue(node, (String)currentFieldName);
        if (fieldValue == null) {
            return;
        }
        String split = dictionary.split();
        String prefix = "";
        DictionaryDataBase dictionaryDataBase = parent = StringUtils.isBlank((CharSequence)dictionary.dicCode()) ? null : ConvertDicAnnotation.coverDicBean(dictionary.dicCode());
        if (parent != null) {
            switch (dictionary.directionType()) {
                case NAME_TO_CODE: 
                case NAME_TO_ID: {
                    prefix = parent.getFullName(split) + split;
                    break;
                }
                case ID_TO_NAME: 
                case ID_TO_CODE: {
                    prefix = parent.getFullId(split) + split;
                    break;
                }
                case CODE_TO_ID: 
                case CODE_TO_NAME: {
                    prefix = parent.getFullCode(split) + split;
                    break;
                }
            }
        }
        if (fieldNames.length > 1) {
            String prefix2 = Arrays.stream(fieldNames).limit((long)fieldNames.length - 1L).map(column -> {
                Object prefixFieldValue = ObjectUtil.getFieldValue((Object)node, (String)column);
                return ConvertDicAnnotation.toDitKey(prefixFieldValue);
            }).filter(Objects::nonNull).collect(Collectors.joining(dictionary.split()));
            prefix = prefix + prefix2 + split;
        }
        String finalPrefix = prefix;
        if (fieldValue.getClass().isArray() || Collection.class.isAssignableFrom(fieldValue.getClass())) {
            List temp = (List)ObjectUtil.to((Object)fieldValue, (TypeReference)new TypeReference<List<Object>>(){});
            List<String> tempList = temp.stream().map(ConvertDicAnnotation::toDitKey).map(a -> finalPrefix + a).collect(Collectors.toList());
            value = ConvertDicAnnotation.parseCollection(dictionary, tempList, new TypeReference(field.getGenericType()));
        } else {
            String temp = ConvertDicAnnotation.toDitKey(fieldValue);
            if (temp == null) {
                return;
            }
            String tempString = Arrays.stream(StringUtils.split((String)temp, (String)",")).map(a -> finalPrefix + a).collect(Collectors.joining(","));
            value = ConvertDicAnnotation.parseString(dictionary, tempString);
        }
        value = ObjectUtil.to((Object)value, (TypeReference)new TypeReference(field.getGenericType()));
        ObjectUtil.setValue(node, (Field)field, (Object)value);
    }

    private static String toDitKey(Object source) {
        if (ObjectUtils.isEmpty((Object)source)) {
            return null;
        }
        String target = source instanceof String ? (String)source : (source instanceof Boolean ? (Boolean.TRUE.equals(source) ? "1" : "0") : (source.getClass().isEnum() ? ((Enum)source).name() : ObjectUtil.toString((Object)source)));
        return target;
    }

    private static <A> A parseCollection(Dictionary dictionary, List<String> fullIndexes, TypeReference<A> typeReference) {
        List targetNameList = fullIndexes.stream().map(fullIndex -> ConvertDicAnnotation.parseString(dictionary, fullIndex)).collect(Collectors.toList());
        if (targetNameList.stream().allMatch(Objects::isNull)) {
            return null;
        }
        if (typeReference.getType() == String.class) {
            return (A)targetNameList.stream().map(a -> a == null ? "" : a).collect(Collectors.joining(","));
        }
        return (A)ObjectUtil.to(targetNameList, typeReference);
    }

    private static String parseString(Dictionary dictionary, String fullIndex) {
        String targetName;
        if (dictionary == null || fullIndex == null) {
            return null;
        }
        boolean isFull = dictionary.isFull();
        String split = dictionary.split();
        String threadCacheKey = fullIndex + dictionary.hashCode();
        if (dicCoverCache != null && dicCoverCache.containsKey(threadCacheKey)) {
            targetName = dicCoverCache.get(threadCacheKey);
            if ("$cloud.agileframework.dic.null".equals(targetName)) {
                targetName = null;
            }
        } else {
            String defaultValue = dictionary.defaultValue();
            StringBuilder builder = new StringBuilder();
            Arrays.stream(fullIndex.split(",")).forEach(c -> {
                DictionaryDataBase targetEntity = null;
                switch (dictionary.directionType()) {
                    case CODE_TO_ID: 
                    case CODE_TO_NAME: {
                        targetEntity = ConvertDicAnnotation.coverDicBean(dictionary.dataSource(), c, split);
                        break;
                    }
                    case NAME_TO_CODE: 
                    case NAME_TO_ID: {
                        targetEntity = ConvertDicAnnotation.coverDicBeanByFullName(dictionary.dataSource(), c, split);
                        break;
                    }
                    case ID_TO_NAME: 
                    case ID_TO_CODE: {
                        targetEntity = (DictionaryDataBase)((Object)((Object)DictionaryUtil.findById(dictionary.dataSource(), c)));
                        break;
                    }
                }
                if (builder.length() > 0) {
                    builder.append(",");
                }
                if (targetEntity == null) {
                    if ("$cloud.agileframework.dic.default".equals(defaultValue)) {
                        builder.append(StringUtil.getSplitByStrLastAtomic((String)c, (String)split));
                    } else if (defaultValue != null) {
                        builder.append(defaultValue);
                    }
                } else if (isFull) {
                    switch (dictionary.directionType()) {
                        case ID_TO_NAME: 
                        case CODE_TO_NAME: {
                            builder.append(targetEntity.getFullName(split));
                            break;
                        }
                        case NAME_TO_ID: 
                        case CODE_TO_ID: {
                            builder.append(targetEntity.getFullId(split));
                            break;
                        }
                        case NAME_TO_CODE: 
                        case ID_TO_CODE: {
                            builder.append(targetEntity.getFullCode(split));
                            break;
                        }
                    }
                } else {
                    switch (dictionary.directionType()) {
                        case ID_TO_NAME: 
                        case CODE_TO_NAME: {
                            builder.append(targetEntity.getName());
                            break;
                        }
                        case NAME_TO_ID: 
                        case CODE_TO_ID: {
                            builder.append(targetEntity.getId());
                            break;
                        }
                        case NAME_TO_CODE: 
                        case ID_TO_CODE: {
                            builder.append(targetEntity.getCode());
                            break;
                        }
                    }
                }
            });
            targetName = builder.toString();
            if ("$cloud.agileframework.dic.null".equals(defaultValue)) {
                targetName = ConvertDicAnnotation.parseNullValue(targetName);
            }
            if (dicCoverCache != null && targetName == null) {
                dicCoverCache.put(threadCacheKey, "$cloud.agileframework.dic.null");
            } else if (dicCoverCache != null) {
                dicCoverCache.put(threadCacheKey, targetName);
            }
        }
        return targetName;
    }
}

