/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.dictionary.util;

import cloud.agileframework.dictionary.DictionaryDataBase;
import cloud.agileframework.dictionary.DictionaryEngine;
import cloud.agileframework.dictionary.util.ConvertBase;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ConvertDicBean
extends ConvertBase {
    public static final String NOT_FOUND_DICTIONARY_OF_FULL_NAME = "not found dictionary of fullName {}";
    public static final String NOT_FOUND_DICTIONARY_OF_FULL_CODE = "not found dictionary of fullCode {}";

    public static DictionaryDataBase coverDicBean(String fullCode) {
        return ConvertDicBean.getDictionary("DICTIONARY_DATA_CACHE", fullCode, DictionaryEngine.CacheType.CODE_CACHE, NOT_FOUND_DICTIONARY_OF_FULL_CODE, "$$");
    }

    public static DictionaryDataBase coverDicBean(String fullCode, String splitChar) {
        return ConvertDicBean.getDictionary("DICTIONARY_DATA_CACHE", fullCode, DictionaryEngine.CacheType.CODE_CACHE, NOT_FOUND_DICTIONARY_OF_FULL_CODE, splitChar);
    }

    public static DictionaryDataBase coverDicBean(String datasource, String fullCode, String splitChar) {
        return ConvertDicBean.getDictionary(datasource, fullCode, DictionaryEngine.CacheType.CODE_CACHE, NOT_FOUND_DICTIONARY_OF_FULL_CODE, splitChar);
    }

    public static DictionaryDataBase coverDicBeanByFullName(String fullName) {
        return ConvertDicBean.getDictionary("DICTIONARY_DATA_CACHE", fullName, DictionaryEngine.CacheType.NAME_CACHE, NOT_FOUND_DICTIONARY_OF_FULL_NAME, "$$");
    }

    public static DictionaryDataBase coverDicBeanByFullName(String fullName, String splitChar) {
        return ConvertDicBean.getDictionary("DICTIONARY_DATA_CACHE", fullName, DictionaryEngine.CacheType.NAME_CACHE, NOT_FOUND_DICTIONARY_OF_FULL_NAME, splitChar);
    }

    public static DictionaryDataBase coverDicBeanByFullName(String datasource, String fullName, String splitChar) {
        return ConvertDicBean.getDictionary(datasource, fullName, DictionaryEngine.CacheType.NAME_CACHE, NOT_FOUND_DICTIONARY_OF_FULL_NAME, splitChar);
    }

    public static DictionaryDataBase coverDicBeanByParent(String parentCode, String name) {
        return ConvertDicBean.coverDicBeanByParent("DICTIONARY_DATA_CACHE", parentCode, name);
    }

    public static DictionaryDataBase coverDicBeanByParent(String datasource, String parentCode, String name) {
        if (StringUtils.isEmpty((CharSequence)parentCode) || StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        DictionaryDataBase dic = ConvertDicBean.coverDicBean(datasource, parentCode, "$$");
        if (dic == null) {
            return null;
        }
        return ConvertDicBean.getDictionary(datasource, dic.getFullName() + "$$" + name, DictionaryEngine.CacheType.NAME_CACHE, NOT_FOUND_DICTIONARY_OF_FULL_NAME, "$$");
    }

    protected static String parseNullValue(String value) {
        if (value == null) {
            return null;
        }
        if (!value.contains("$cloud.agileframework.dic.null")) {
            return value;
        }
        if (!value.contains(",")) {
            return null;
        }
        String[] array = StringUtils.split((String)value, (String)",");
        boolean allNull = Arrays.stream(array).allMatch("$cloud.agileframework.dic.null"::equals);
        if (allNull) {
            return null;
        }
        return Arrays.stream(array).map(node -> {
            if ("$cloud.agileframework.dic.null".equals(node)) {
                return "";
            }
            return node;
        }).collect(Collectors.joining(","));
    }
}

