/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.dictionary.util;

import cloud.agileframework.common.util.string.StringUtil;
import cloud.agileframework.dictionary.DictionaryDataBase;
import cloud.agileframework.dictionary.DictionaryEngine;
import cloud.agileframework.dictionary.util.ConvertDicBean;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ConvertDicCode
extends ConvertDicBean {
    public static String coverDicCode(String fullNames) {
        return ConvertDicCode.coverDicCode("DICTIONARY_DATA_CACHE", fullNames, "$cloud.agileframework.dic.null", false, "$$");
    }

    public static String coverDicCode(String fullNames, String defaultCode) {
        return ConvertDicCode.coverDicCode("DICTIONARY_DATA_CACHE", fullNames, defaultCode, false, "$$");
    }

    public static String coverDicCode(String datasource, String fullNames, String defaultCode) {
        return ConvertDicCode.coverDicCode(datasource, fullNames, defaultCode, false, "$$");
    }

    public static String coverDicCode(String fullNames, String defaultCode, boolean isFull, String splitChar) {
        return ConvertDicCode.coverDicCode("DICTIONARY_DATA_CACHE", fullNames, defaultCode, isFull, splitChar);
    }

    public static String coverDicCodeByParentCode(String datasource, String parentCode, String names) {
        return Arrays.stream(names.split(",")).map(name -> ConvertDicCode.coverDicBeanByParent(datasource, parentCode, name)).filter(Objects::nonNull).map(DictionaryDataBase::getCode).collect(Collectors.joining(","));
    }

    public static String coverDicCodeByParentCode(String parentCode, String names) {
        return ConvertDicCode.coverDicCodeByParentCode("DICTIONARY_DATA_CACHE", parentCode, names);
    }

    public static String coverDicCodeByParent(String parentName, String names) {
        return ConvertDicCode.coverDicCodeByParent(parentName, names, "$cloud.agileframework.dic.null", false, "$$");
    }

    public static String coverDicCodeByParent(String parentName, String names, String defaultCode) {
        return ConvertDicCode.coverDicCodeByParent(parentName, names, defaultCode, false, "$$");
    }

    public static String coverDicCodeByParent(String parentName, String names, String defaultCode, boolean isFull, String splitChar) {
        return ConvertDicCode.coverDicCodeByParent("DICTIONARY_DATA_CACHE", parentName, names, defaultCode, isFull, splitChar);
    }

    public static String coverDicCodeByParent(String datasource, String parentName, String names, String defaultCode, boolean isFull, String splitChar) {
        if (StringUtils.isBlank((CharSequence)parentName) || StringUtils.isBlank((CharSequence)names)) {
            return defaultCode;
        }
        DictionaryDataBase parent = ConvertDicCode.getDictionary(datasource, parentName, DictionaryEngine.CacheType.NAME_CACHE, "not found dictionary of fullName {}", splitChar);
        if (parent == null) {
            return defaultCode;
        }
        if (isFull) {
            defaultCode = parent.getFullCode() + splitChar + defaultCode;
        }
        String finalDefaultCode = defaultCode;
        return Arrays.stream(names.split(",")).map(code -> ConvertDicCode.coverDicCode(datasource, parent.getFullName() + splitChar + code, finalDefaultCode, isFull, splitChar)).collect(Collectors.joining(","));
    }

    public static String coverDicCode(String datasource, String fulNames, String defaultCode, boolean isFull, String splitChar) {
        if (fulNames == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        Arrays.stream(fulNames.split(",")).forEach(c -> {
            DictionaryDataBase targetEntity = ConvertDicCode.coverDicBeanByFullName(datasource, c, splitChar);
            if (builder.length() > 0) {
                builder.append(",");
            }
            if (targetEntity == null) {
                if ("$cloud.agileframework.dic.default".equals(defaultCode)) {
                    builder.append(StringUtil.getSplitByStrLastAtomic((String)c, (String)splitChar));
                } else if (defaultCode != null) {
                    builder.append(defaultCode);
                }
            } else if (isFull) {
                builder.append(targetEntity.getFullCode(splitChar));
            } else {
                builder.append(targetEntity.getCode());
            }
        });
        if ("$cloud.agileframework.dic.null".equals(defaultCode)) {
            return ConvertDicCode.parseNullValue(builder.toString());
        }
        return builder.toString();
    }
}

