/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.dictionary.util;

import cloud.agileframework.dictionary.util.ConvertDicName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConvertDicMap
extends ConvertDicName {
    static final String CODE_FORMAT = "%s$$%s";

    public static <T extends Map<String, ?>> List<Map<String, Object>> coverMapDictionary(List<T> list, String dictionaryCode, String suffix, String column) {
        return ConvertDicMap.coverMapDictionary(list, new String[]{dictionaryCode}, suffix, new String[]{column}, "$$");
    }

    public static <T extends Map<String, ?>> List<Map<String, Object>> coverMapDictionary(List<T> list, String dictionaryCode, String suffix, String column, String splitChar) {
        return ConvertDicMap.coverMapDictionary(list, new String[]{dictionaryCode}, suffix, new String[]{column}, splitChar);
    }

    public static <T extends Map<String, ?>> List<Map<String, Object>> coverMapDictionary(List<T> list, String[] dictionaryCodes, String suffix, String[] columns) {
        return ConvertDicMap.coverMapDictionary(list, dictionaryCodes, suffix, columns, "$$");
    }

    public static <T extends Map<String, ?>> List<Map<String, Object>> coverMapDictionary(List<T> list, String[] dictionaryCodes, String suffix, String[] columns, String splitChar) {
        if (dictionaryCodes == null || columns == null || dictionaryCodes.length != columns.length) {
            throw new IllegalArgumentException("dictionaryCodes and columns should be the same length");
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(list.size());
        for (Map o : list) {
            result.add(ConvertDicMap.coverMapDictionary(o, dictionaryCodes, suffix, columns, splitChar));
        }
        return result;
    }

    public static <T extends Map<String, ?>> Map<String, Object> coverMapDictionary(T o, String[] dictionaryCodes, String suffix, String[] columns) {
        return ConvertDicMap.coverMapDictionary(o, dictionaryCodes, suffix, columns, "$$");
    }

    public static <T extends Map<String, ?>> Map<String, Object> coverMapDictionary(T o, String[] dictionaryCodes, String suffix, String[] columns, String splitChar) {
        T map = o;
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            map.put((String)(column + suffix), (String)ConvertDicMap.coverDicName(dictionaryCodes[i] + splitChar + map.get(column)));
        }
        return map;
    }
}

