/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.dictionary.util;

import cloud.agileframework.common.util.string.StringUtil;
import cloud.agileframework.dictionary.DictionaryDataBase;
import cloud.agileframework.dictionary.util.ConvertDicCode;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ConvertDicName
extends ConvertDicCode {
    public static String coverDicName(String fullCodes) {
        return ConvertDicName.coverDicName("DICTIONARY_DATA_CACHE", fullCodes, "$cloud.agileframework.dic.null", false, "$$");
    }

    public static String coverDicName(String fullCodes, String defaultName) {
        return ConvertDicName.coverDicName("DICTIONARY_DATA_CACHE", fullCodes, defaultName, false, "$$");
    }

    public static String coverDicName(String datasource, String fullCodes, String defaultName) {
        return ConvertDicName.coverDicName(datasource, fullCodes, defaultName, false, "$$");
    }

    public static String coverDicNameByParent(String parentCode, String codes) {
        return ConvertDicName.coverDicNameByParent("DICTIONARY_DATA_CACHE", parentCode, codes, "$cloud.agileframework.dic.null", false, "$$");
    }

    public static String coverDicNameByParent(String parentCode, String codes, String defaultValue) {
        return ConvertDicName.coverDicNameByParent("DICTIONARY_DATA_CACHE", parentCode, codes, defaultValue, false, "$$");
    }

    public static String coverDicNameByParent(String parentCode, String codes, String defaultValue, boolean isFull, String splitChar) {
        return ConvertDicName.coverDicNameByParent("DICTIONARY_DATA_CACHE", parentCode, codes, defaultValue, isFull, splitChar);
    }

    public static String coverDicNameByParent(String datasource, String parentCode, String codes, String defaultValue, boolean isFull, String splitChar) {
        if (StringUtils.isBlank((CharSequence)parentCode) || StringUtils.isBlank((CharSequence)codes)) {
            return defaultValue;
        }
        DictionaryDataBase parent = ConvertDicName.coverDicBean(datasource, parentCode, splitChar);
        if (parent == null) {
            return defaultValue;
        }
        if (isFull) {
            defaultValue = parent.getFullName() + splitChar + defaultValue;
        }
        String finalDefaultValue = defaultValue;
        return Arrays.stream(codes.split(",")).map(code -> ConvertDicName.coverDicName(datasource, parent.getFullCode() + splitChar + code, finalDefaultValue, isFull, splitChar)).collect(Collectors.joining(","));
    }

    public static String coverDicName(String fullCodes, String defaultName, boolean isFull, String splitChar) {
        return ConvertDicName.coverDicName("DICTIONARY_DATA_CACHE", fullCodes, defaultName, isFull, splitChar);
    }

    public static String coverDicName(String datasource, String fullCodes, String defaultName, boolean isFull, String splitChar) {
        if (fullCodes == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        Arrays.stream(fullCodes.split(",")).forEach(c -> {
            DictionaryDataBase targetEntity = ConvertDicName.coverDicBean(datasource, c, splitChar);
            if (builder.length() > 0) {
                builder.append(",");
            }
            if (targetEntity == null) {
                if ("$cloud.agileframework.dic.default".equals(defaultName)) {
                    builder.append(StringUtil.getSplitByStrLastAtomic((String)c, (String)splitChar));
                } else if (defaultName != null) {
                    builder.append(defaultName);
                }
            } else if (isFull) {
                builder.append(targetEntity.getFullName(splitChar));
            } else {
                builder.append(targetEntity.getName());
            }
        });
        if ("$cloud.agileframework.dic.null".equals(defaultName)) {
            return ConvertDicName.parseNullValue(builder.toString());
        }
        return builder.toString();
    }
}

