/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.dictionary.util;

import cloud.agileframework.dictionary.DictionaryDataBase;
import cloud.agileframework.dictionary.cache.DictionaryCacheUtil;
import cloud.agileframework.dictionary.cache.NotFoundCacheException;
import cloud.agileframework.dictionary.util.ConvertDicAnnotation;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;

public class DictionaryUtil
extends ConvertDicAnnotation {
    public static <D extends DictionaryDataBase> D findById(String datasource, String id) {
        try {
            return DictionaryCacheUtil.getDictionaryCache(datasource).findById(datasource, id);
        }
        catch (NotFoundCacheException e) {
            throw new RuntimeException(e);
        }
    }

    public static <D extends DictionaryDataBase> ConcurrentSkipListSet<D> findByParentId(String datasource, String parentId) {
        SortedSet<DictionaryDataBase> cacheData = DictionaryUtil.findAll(datasource);
        List list = cacheData.stream().filter(data -> data.getParentId().equals(parentId)).map(a -> a).collect(Collectors.toList());
        return (ConcurrentSkipListSet)SerializationUtils.clone(new ConcurrentSkipListSet(list));
    }

    public static SortedSet<DictionaryDataBase> findAll(String datasource) {
        try {
            SortedSet<DictionaryDataBase> treeSet = DictionaryCacheUtil.getDictionaryCache(datasource).getDataByDatasource(datasource);
            return treeSet;
        }
        catch (NotFoundCacheException e) {
            e.printStackTrace();
            return new ConcurrentSkipListSet<DictionaryDataBase>();
        }
    }
}

