/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.security.config;

import cloud.agileframework.security.filter.login.CustomRememberMeServices;
import cloud.agileframework.security.filter.login.CustomerUserDetailsService;
import cloud.agileframework.security.filter.login.InMemoryUserDetailsServiceImpl;
import cloud.agileframework.security.provider.CompleteFormLoginValidateProvider;
import cloud.agileframework.security.provider.ErrorSignLockLoginValidateProvider;
import cloud.agileframework.security.provider.KaptchaLoginValidateProvider;
import cloud.agileframework.security.provider.LoginStrategyLoginValidateProvider;
import cloud.agileframework.security.provider.LoginValidateProvider;
import cloud.agileframework.security.provider.PasswordLoginValidateProvider;
import cloud.agileframework.security.provider.PasswordProvider;
import cloud.agileframework.security.provider.SecurityResultProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.security.web.authentication.RememberMeServices;

public class SecurityAboutConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={PasswordProvider.class})
    PasswordProvider passwordProvider() {
        return ciphertext -> ciphertext;
    }

    @Bean
    @ConditionalOnMissingBean(value={SecurityResultProvider.class})
    public SecurityResultProvider securityResultHandler() {
        return new SecurityResultProvider(){};
    }

    @Bean
    @Order(value=4)
    public LoginStrategyLoginValidateProvider loginStrategyLoginValidateProvider() {
        return new LoginStrategyLoginValidateProvider();
    }

    @Bean
    @Order(value=3)
    @ConditionalOnClass(value={KaptchaLoginValidateProvider.class})
    @ConditionalOnProperty(name={"enable"}, prefix="agile.kaptcha", matchIfMissing=true)
    public LoginValidateProvider kaptchaLoginValidateProvider() {
        return new KaptchaLoginValidateProvider();
    }

    @Bean
    @Order(value=2)
    public CompleteFormLoginValidateProvider completeFormLoginValidateProvider() {
        return new CompleteFormLoginValidateProvider();
    }

    @Bean
    @Order(value=1)
    public ErrorSignLockLoginValidateProvider errorSignLockLoginValidateProvider() {
        return new ErrorSignLockLoginValidateProvider();
    }

    @Bean
    @Order(value=1)
    public PasswordLoginValidateProvider passwordLoginValidateProvider() {
        return new PasswordLoginValidateProvider();
    }

    @Bean
    public RememberMeServices rememberMeServices() {
        return new CustomRememberMeServices();
    }

    @Bean
    @ConditionalOnMissingBean(value={CustomerUserDetailsService.class})
    public InMemoryUserDetailsServiceImpl inMemoryUserDetailsService() {
        return new InMemoryUserDetailsServiceImpl();
    }
}

