/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.security.controller;

import cloud.agileframework.security.properties.SecurityProperties;
import cloud.agileframework.security.provider.SecurityResultProvider;
import cloud.agileframework.security.util.TokenUtil;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.web.servlet.error.AbstractErrorController;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ForwardController
extends AbstractErrorController {
    @Autowired
    private SecurityResultProvider securityResultProvider;
    @Autowired
    private SecurityProperties securityProperties;

    public ForwardController(ErrorAttributes errorAttributes, List<ErrorViewResolver> errorViewResolvers) {
        super(errorAttributes, errorViewResolvers);
    }

    @RequestMapping(value={"${agile.security.fail-forward-url:/fail}", "${server.error.path:${error.path:/error}}"})
    public Object error(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        this.handleStatus(request, response);
        this.handleToken(request, response);
        return this.handleException(request, response);
    }

    public void handleStatus(HttpServletRequest request, HttpServletResponse response) {
        Object statusCode = request.getAttribute("javax.servlet.error.status_code");
        if (statusCode instanceof Integer) {
            response.setStatus(((Integer)statusCode).intValue());
        }
    }

    public Object handleException(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        Object e = request.getAttribute("SPRING_SECURITY_403_EXCEPTION");
        if (!(e instanceof Throwable)) {
            e = request.getAttribute("SPRING_SECURITY_LAST_EXCEPTION");
        }
        if (!(e instanceof Throwable)) {
            e = request.getAttribute("javax.servlet.error.exception");
        }
        if (e instanceof Throwable) {
            return this.securityResultProvider.accessException(request, response, this.cause((Throwable)e));
        }
        return null;
    }

    public void handleToken(HttpServletRequest request, HttpServletResponse response) {
        Object token = request.getAttribute(this.securityProperties.getTokenHeader());
        if (token instanceof String) {
            TokenUtil.notice(request, response, (String)token);
        }
    }

    @ResponseBody
    @RequestMapping(value={"${agile.security.success-forward-url:/success}"})
    public Object success(HttpServletRequest request, HttpServletResponse response) {
        return this.securityResultProvider.loginSuccess(request, response, (UsernamePasswordAuthenticationToken)SecurityContextHolder.getContext().getAuthentication());
    }

    @ResponseBody
    @RequestMapping(value={"${agile.security.success-logout-forward-url:/logout-success}"})
    public Object logoutSuccess(HttpServletRequest request, HttpServletResponse response) {
        return this.securityResultProvider.logoutSuccess(request, response, (String)request.getAttribute("SPRING_SECURITY_LOGOUT_USERNAME"), (String)request.getAttribute("SPRING_SECURITY_LOGOUT_TOKEN"));
    }

    private Throwable cause(Throwable throwable) {
        Throwable cause = throwable.getCause();
        if (cause == null) {
            return throwable;
        }
        return this.cause(cause);
    }
}

