/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.security.event;

import cloud.agileframework.cache.util.CacheUtil;
import cloud.agileframework.security.event.MenuEvent;
import cloud.agileframework.security.menu.AbstractMenuDetail;
import cloud.agileframework.security.menu.MenuManager;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.CollectionUtils;

public class MenuEventListener
implements ApplicationListener<MenuEvent> {
    @Autowired
    private MenuManager manager;

    public void onApplicationEvent(MenuEvent event) {
        UserDetails userDetails = event.getUserDetails();
        if (userDetails == null) {
            return;
        }
        List<AbstractMenuDetail> menu = this.findMenuByUser(userDetails);
        if (CollectionUtils.isEmpty(menu)) {
            return;
        }
        CacheUtil.getCache((String)"user-menu").put((Object)userDetails.getUsername(), menu);
    }

    private List<AbstractMenuDetail> findMenuByUser(UserDetails user) {
        if (null == user) {
            return new ArrayList<AbstractMenuDetail>();
        }
        return this.manager.byUser(user.getAuthorities());
    }
}

