/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.security.filter.login;

import cloud.agileframework.security.properties.LockType;
import cloud.agileframework.spring.util.ServletUtil;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;

public class ErrorSignInfo {
    public static final String REQUEST_ATTR = "AGILE_LOGIN_USERNAME";
    private final String lockObject;
    private final String ip;
    private final String sessionId;
    private final String account;
    private Date lockTime;
    private Date timeOut;

    public void setTimeOut(Date timeOut) {
        this.timeOut = timeOut;
    }

    public void setLockTime(Date lockTime) {
        this.lockTime = lockTime;
    }

    public static ErrorSignInfo of(HttpServletRequest request, String sourceUsername, LockType[] lockTypes) {
        ErrorSignInfoBuilder builder = ErrorSignInfo.builder();
        StringBuilder lockObject = new StringBuilder();
        if (ArrayUtils.contains((Object[])lockTypes, (Object)((Object)LockType.IP))) {
            lockObject.append(ServletUtil.getCurrentRequestIP());
            builder.ip(ServletUtil.getRequestIP((HttpServletRequest)request));
        }
        if (ArrayUtils.contains((Object[])lockTypes, (Object)((Object)LockType.SESSION_ID))) {
            lockObject.append(request.getSession().getId());
            builder.sessionId(request.getSession().getId());
        }
        if (ArrayUtils.contains((Object[])lockTypes, (Object)((Object)LockType.ACCOUNT))) {
            lockObject.append(sourceUsername);
            builder.account(sourceUsername);
        }
        return builder.lockObject(lockObject.toString()).build();
    }

    ErrorSignInfo(String lockObject, String ip, String sessionId, String account, Date lockTime, Date timeOut) {
        this.lockObject = lockObject;
        this.ip = ip;
        this.sessionId = sessionId;
        this.account = account;
        this.lockTime = lockTime;
        this.timeOut = timeOut;
    }

    public static ErrorSignInfoBuilder builder() {
        return new ErrorSignInfoBuilder();
    }

    public String getLockObject() {
        return this.lockObject;
    }

    public String getIp() {
        return this.ip;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getAccount() {
        return this.account;
    }

    public Date getLockTime() {
        return this.lockTime;
    }

    public Date getTimeOut() {
        return this.timeOut;
    }

    public static class ErrorSignInfoBuilder {
        private String lockObject;
        private String ip;
        private String sessionId;
        private String account;
        private Date lockTime;
        private Date timeOut;

        ErrorSignInfoBuilder() {
        }

        public ErrorSignInfoBuilder lockObject(String lockObject) {
            this.lockObject = lockObject;
            return this;
        }

        public ErrorSignInfoBuilder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public ErrorSignInfoBuilder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public ErrorSignInfoBuilder account(String account) {
            this.account = account;
            return this;
        }

        public ErrorSignInfoBuilder lockTime(Date lockTime) {
            this.lockTime = lockTime;
            return this;
        }

        public ErrorSignInfoBuilder timeOut(Date timeOut) {
            this.timeOut = timeOut;
            return this;
        }

        public ErrorSignInfo build() {
            return new ErrorSignInfo(this.lockObject, this.ip, this.sessionId, this.account, this.lockTime, this.timeOut);
        }

        public String toString() {
            return "ErrorSignInfo.ErrorSignInfoBuilder(lockObject=" + this.lockObject + ", ip=" + this.ip + ", sessionId=" + this.sessionId + ", account=" + this.account + ", lockTime=" + this.lockTime + ", timeOut=" + this.timeOut + ")";
        }
    }
}

