/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.security.filter.login;

import cloud.agileframework.security.filter.login.CustomerUserDetails;
import cloud.agileframework.security.properties.LoginStrategy;
import java.util.Collection;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class InMemoryUserDetails
implements CustomerUserDetails {
    private long id;
    private LoginStrategy loginStrategy;
    private Collection<? extends GrantedAuthority> authorities;
    private String password;
    private String username;
    private boolean accountNonExpired;
    private boolean accountNonLocked;
    private boolean credentialsNonExpired;
    private boolean enabled;

    public static InMemoryUserDetails of(UserDetails userDetails) {
        if (userDetails instanceof InMemoryUserDetails) {
            return (InMemoryUserDetails)userDetails;
        }
        InMemoryUserDetails inMemoryUserDetails = new InMemoryUserDetails();
        inMemoryUserDetails.authorities = userDetails.getAuthorities();
        inMemoryUserDetails.password = userDetails.getPassword();
        inMemoryUserDetails.username = userDetails.getUsername();
        inMemoryUserDetails.accountNonExpired = userDetails.isAccountNonExpired();
        inMemoryUserDetails.accountNonLocked = userDetails.isAccountNonLocked();
        inMemoryUserDetails.credentialsNonExpired = userDetails.isCredentialsNonExpired();
        inMemoryUserDetails.enabled = userDetails.isEnabled();
        return inMemoryUserDetails;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setLoginStrategy(LoginStrategy loginStrategy) {
        this.loginStrategy = loginStrategy;
    }

    public void setAuthorities(Collection<? extends GrantedAuthority> authorities) {
        this.authorities = authorities;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setAccountNonExpired(boolean accountNonExpired) {
        this.accountNonExpired = accountNonExpired;
    }

    public void setAccountNonLocked(boolean accountNonLocked) {
        this.accountNonLocked = accountNonLocked;
    }

    public void setCredentialsNonExpired(boolean credentialsNonExpired) {
        this.credentialsNonExpired = credentialsNonExpired;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Long id() {
        return this.id;
    }

    @Override
    public LoginStrategy getLoginStrategy() {
        return this.loginStrategy;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return this.accountNonExpired;
    }

    public boolean isAccountNonLocked() {
        return this.accountNonLocked;
    }

    public boolean isCredentialsNonExpired() {
        return this.credentialsNonExpired;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

